<!-- API Report Version: 2.3 -->

## API Report File for "@atlaskit/modal-dialog"

> Do not edit this file. This report is auto-generated using [API Extractor](https://api-extractor.com/).
> [Learn more about API reports](https://hello.atlassian.net/wiki/spaces/UR/pages/1825484529/Package+API+Reports)

### Table of contents

- [Main Entry Types](#main-entry-types)
- [Peer Dependencies](#peer-dependencies)

### Main Entry Types

<!--SECTION START: Main Entry Types-->

```ts
/// <reference types="react" />

import { ExitingPersistenceProps } from '@atlaskit/motion/exiting-persistence';
import { jsx } from '@emotion/react';
import { default as React_2 } from 'react';
import { ReactNode } from 'react';
import { RefObject } from 'react';
import type { UIAnalyticsEvent } from '@atlaskit/analytics-next';

// @public (undocumented)
export type Appearance = 'danger' | 'warning';

// @public (undocumented)
export type KeyboardOrMouseEvent =
  | KeyboardEvent
  | React_2.KeyboardEvent<any>
  | React_2.MouseEvent<any>;

// @public (undocumented)
export type ModalAttributes = {
  testId?: ModalDialogProps['testId'];
  titleId: string;
  onClose?: OnCloseHandler;
};

// @public
export const ModalBody: (props: ModalBodyProps) => jsx.JSX.Element;

// @public (undocumented)
export interface ModalBodyProps {
  children: React_2.ReactNode;
  testId?: string;
}

// @public (undocumented)
export interface ModalDialogProps {
  autoFocus?: RefObject<HTMLElement | null | undefined> | boolean;
  children?: React_2.ReactNode;
  height?: number | string;
  isBlanketHidden?: boolean;
  label?: string;
  onClose?: OnCloseHandler;
  onCloseComplete?: OnCloseCompleteHandler;
  onOpenComplete?: OnOpenCompleteHandler;
  onStackChange?: OnStackChangeHandler;
  shouldCloseOnEscapePress?: boolean;
  shouldCloseOnOverlayClick?: boolean;
  shouldScrollInViewport?: boolean;
  stackIndex?: number;
  testId?: string;
  width?: WidthNames | number | string;
}

// @public
export const ModalFooter: (props: ModalFooterProps) => jsx.JSX.Element;

// @public (undocumented)
export interface ModalFooterProps {
  children?: ReactNode;
  testId?: string;
}

// @public
export const ModalHeader: (props: ModalHeaderProps) => jsx.JSX.Element;

// @public (undocumented)
export interface ModalHeaderProps {
  children?: React_2.ReactNode;
  testId?: string;
}

// @public
export const ModalTitle: (props: ModalTitleProps) => jsx.JSX.Element;

// @public (undocumented)
export interface ModalTitleProps {
  appearance?: Appearance;
  children?: ReactNode;
  isMultiline?: boolean;
  testId?: string;
}

// @public
export const ModalTransition: (
  props: Pick<ExitingPersistenceProps, 'children'>,
) => JSX.Element;

// @public
const ModalWrapper: (props: ModalDialogProps) => jsx.JSX.Element;
export default ModalWrapper;

// @public (undocumented)
export type OnCloseCompleteHandler = (element: HTMLElement) => void;

// @public (undocumented)
export type OnCloseHandler = (
  e: KeyboardOrMouseEvent,
  analyticEvent: UIAnalyticsEvent,
) => void;

// @public (undocumented)
export type OnOpenCompleteHandler = (
  node: HTMLElement,
  isAppearing: boolean,
) => void;

// @public (undocumented)
export type OnStackChangeHandler = (stackIndex: number) => void;

// @public (undocumented)
export const useModal: () => ModalAttributes;

// @public (undocumented)
type WidthNames = 'large' | 'medium' | 'small' | 'x-large';

// (No @packageDocumentation comment for this package)
```

<!--SECTION END: Main Entry Types-->

### Peer Dependencies

<!--SECTION START: Peer Dependencies-->

```json
{
  "react": "^16.8.0"
}
```

<!--SECTION END: Peer Dependencies-->
