"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
/* eslint-disable @atlaskit/design-system/use-primitives */
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box'
});
var blockBleedMap = {
  'space.025': (0, _react2.css)({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-050, 2px)", ")")
  }),
  'space.050': (0, _react2.css)({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-050, 4px)", ")")
  }),
  'space.100': (0, _react2.css)({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-100, 8px)", ")")
  }),
  'space.200': (0, _react2.css)({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-200, 16px)", ")")
  }),
  'space.150': (0, _react2.css)({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-150, 12px)", ")")
  })
};
var inlineBleedMap = {
  'space.025': (0, _react2.css)({
    marginInline: "calc(-1 * ".concat("var(--ds-space-025, 2px)", ")")
  }),
  'space.050': (0, _react2.css)({
    marginInline: "calc(-1 * ".concat("var(--ds-space-050, 4px)", ")")
  }),
  'space.100': (0, _react2.css)({
    marginInline: "calc(-1 * ".concat("var(--ds-space-100, 8px)", ")")
  }),
  'space.200': (0, _react2.css)({
    marginInline: "calc(-1 * ".concat("var(--ds-space-200, 16px)", ")")
  }),
  'space.150': (0, _react2.css)({
    marginInline: "calc(-1 * ".concat("var(--ds-space-150, 12px)", ")")
  })
};

/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
var Bleed = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    inline = _ref.inline,
    block = _ref.block,
    all = _ref.all,
    xcss = _ref.xcss;
  var xcssStyles = xcss && (0, _xcss.parseXcss)(xcss);
  return (0, _react2.jsx)("div", {
    css: [baseStyles, (inline || all) && inlineBleedMap[inline || all], (block || all) && blockBleedMap[block || all],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssStyles],
    "data-testid": testId
  }, children);
});
Bleed.displayName = 'Bleed';
var _default = Bleed;
exports.default = _default;