"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
var _baseBox = require("./internal/base-box");
var _excluded = ["as", "children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "style", "testId", "xcss"],
  _excluded2 = ["className"];
/** @jsx jsx */
/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
var Box = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var as = _ref.as,
    children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  var className = xcss && (0, _xcss.parseXcss)(xcss);
  return (0, _react2.jsx)(_baseBox.BaseBox, (0, _extends2.default)({
    as: as,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    style: style,
    testId: testId,
    ref: ref
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: className
  }, safeHtmlAttributes), children);
});
Box.displayName = 'Box';
var _default = Box;
exports.default = _default;