"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _styleMaps = require("../xcss/style-maps.partial");
var _xcss = require("../xcss/xcss");
/** @jsx jsx */

var justifyContentMap = {
  start: (0, _react2.css)({
    justifyContent: 'start'
  }),
  center: (0, _react2.css)({
    justifyContent: 'center'
  }),
  end: (0, _react2.css)({
    justifyContent: 'end'
  }),
  'space-between': (0, _react2.css)({
    justifyContent: 'space-between'
  }),
  'space-around': (0, _react2.css)({
    justifyContent: 'space-around'
  }),
  'space-evenly': (0, _react2.css)({
    justifyContent: 'space-evenly'
  }),
  stretch: (0, _react2.css)({
    justifyContent: 'stretch'
  })
};
var justifyItemsMap = {
  start: (0, _react2.css)({
    justifyItems: 'start'
  }),
  center: (0, _react2.css)({
    justifyItems: 'center'
  }),
  end: (0, _react2.css)({
    justifyItems: 'end'
  }),
  stretch: (0, _react2.css)({
    justifyItems: 'stretch'
  })
};
var alignContentMap = {
  start: (0, _react2.css)({
    alignContent: 'start'
  }),
  center: (0, _react2.css)({
    alignContent: 'center'
  }),
  end: (0, _react2.css)({
    alignContent: 'end'
  }),
  'space-between': (0, _react2.css)({
    alignContent: 'space-between'
  }),
  'space-around': (0, _react2.css)({
    alignContent: 'space-around'
  }),
  'space-evenly': (0, _react2.css)({
    alignContent: 'space-evenly'
  }),
  stretch: (0, _react2.css)({
    alignContent: 'stretch'
  })
};
var alignItemsMap = {
  start: (0, _react2.css)({
    alignItems: 'start'
  }),
  center: (0, _react2.css)({
    alignItems: 'center'
  }),
  baseline: (0, _react2.css)({
    alignItems: 'baseline'
  }),
  end: (0, _react2.css)({
    alignItems: 'end'
  })
};
var baseStyles = (0, _react2.css)({
  display: 'grid',
  boxSizing: 'border-box'
});
var gridAutoFlowMap = {
  row: (0, _react2.css)({
    gridAutoFlow: 'row'
  }),
  column: (0, _react2.css)({
    gridAutoFlow: 'column'
  }),
  dense: (0, _react2.css)({
    gridAutoFlow: 'dense'
  }),
  'row dense': (0, _react2.css)({
    gridAutoFlow: 'row dense'
  }),
  'column dense': (0, _react2.css)({
    gridAutoFlow: 'column dense'
  })
};

/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
var Grid = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignItems,
    alignContent = _ref.alignContent,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    id = _ref.id,
    role = _ref.role,
    testId = _ref.testId,
    autoFlow = _ref.autoFlow,
    gridTemplateAreas = _ref.templateAreas,
    gridTemplateRows = _ref.templateRows,
    gridTemplateColumns = _ref.templateColumns,
    xcss = _ref.xcss;
  var Component = as || 'div';
  var xcssClassName = xcss && (0, _xcss.parseXcss)(xcss);
  var style = gridTemplateAreas || gridTemplateColumns || gridTemplateRows ? Object.assign({}, {
    gridTemplateAreas: gridTemplateAreas ? gridTemplateAreas.map(function (str) {
      return "\"".concat(str, "\"");
    }).join('\n') : undefined,
    gridTemplateColumns: gridTemplateColumns,
    gridTemplateRows: gridTemplateRows
  }) : undefined;
  return (0, _react2.jsx)(Component, {
    id: id,
    role: role,
    style: style,
    css: [baseStyles, gap && _styleMaps.spaceStylesMap.gap[gap], columnGap && _styleMaps.spaceStylesMap.columnGap[columnGap], rowGap && _styleMaps.spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], alignContent && alignContentMap[alignContent], justifyContent && justifyContentMap[justifyContent], autoFlow && gridAutoFlowMap[autoFlow],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssClassName && xcssClassName],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Grid.displayName = 'Grid';
var _default = Grid;
exports.default = _default;