"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
var _flex = _interopRequireDefault(require("./flex"));
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */

var flexGrowMap = {
  hug: (0, _xcss.xcss)({
    flexGrow: 0
  }),
  fill: (0, _xcss.xcss)({
    width: '100%',
    flexGrow: 1
  })
};
var separatorStyles = (0, _react2.css)({
  color: "var(--ds-text-subtle, #42526E)",
  marginBlock: "var(--ds-space-0, 0px)",
  marginInline: "calc(-1 * ".concat("var(--ds-space-025, 2px)", ")"),
  pointerEvents: 'none',
  userSelect: 'none'
});
var Separator = function Separator(_ref) {
  var children = _ref.children;
  return (0, _react2.jsx)("span", {
    css: separatorStyles
  }, children);
};

/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
var Inline = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var as = _ref2.as,
    alignInline = _ref2.alignInline,
    _ref2$alignBlock = _ref2.alignBlock,
    alignItems = _ref2$alignBlock === void 0 ? 'start' : _ref2$alignBlock,
    _ref2$shouldWrap = _ref2.shouldWrap,
    shouldWrap = _ref2$shouldWrap === void 0 ? false : _ref2$shouldWrap,
    spread = _ref2.spread,
    grow = _ref2.grow,
    space = _ref2.space,
    rowSpace = _ref2.rowSpace,
    separator = _ref2.separator,
    xcss = _ref2.xcss,
    testId = _ref2.testId,
    rawChildren = _ref2.children;
  var separatorComponent = typeof separator === 'string' ? (0, _react2.jsx)(Separator, null, separator) : separator;
  var children = separatorComponent ? _react.Children.toArray(rawChildren).filter(Boolean).map(function (child, index) {
    return (0, _react2.jsx)(_react.Fragment, {
      key: index
    }, separator && index > 0 ? separatorComponent : null, child);
  }) : rawChildren;
  var justifyContent = spread || alignInline;
  return (0, _react2.jsx)(_flex.default, {
    as: as,
    alignItems: alignItems,
    justifyContent: justifyContent,
    direction: "row",
    gap: space,
    rowGap: rowSpace,
    wrap: shouldWrap ? 'wrap' : undefined,
    xcss: grow ? [flexGrowMap[grow]].concat((0, _toConsumableArray2.default)(Array.isArray(xcss) ? xcss : [xcss])) :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Inline.displayName = 'Inline';
var _default = Inline;
exports.default = _default;