"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BaseBox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _styleMaps = require("../../xcss/style-maps.partial");
var _excluded = ["as", "className", "children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "style", "testId", "css"];
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
// Without this type annotation on Box we don't get autocomplete for props due to forwardRef types

/**
 * __Box__
 *
 * Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * @internal
 */
var BaseBox = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    as = _ref$as === void 0 ? 'div' : _ref$as,
    className = _ref.className,
    children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    style = _ref.style,
    testId = _ref.testId,
    css = _ref.css,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var Component = as;
  var node = (0, _react2.jsx)(Component, (0, _extends2.default)({
    style: style,
    ref: ref
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, htmlAttributes, {
    className: className,
    css: [baseStyles, backgroundColor && _styleMaps.backgroundColorStylesMap[backgroundColor], padding && _styleMaps.paddingStylesMap.padding[padding], paddingBlock && _styleMaps.paddingStylesMap.paddingBlock[paddingBlock], paddingBlockStart && _styleMaps.paddingStylesMap.paddingBlockStart[paddingBlockStart], paddingBlockEnd && _styleMaps.paddingStylesMap.paddingBlockEnd[paddingBlockEnd], paddingInline && _styleMaps.paddingStylesMap.paddingInline[paddingInline], paddingInlineStart && _styleMaps.paddingStylesMap.paddingInlineStart[paddingInlineStart], paddingInlineEnd && _styleMaps.paddingStylesMap.paddingInlineEnd[paddingInlineEnd]],
    "data-testid": testId
  }), children);
  return node;
});
exports.BaseBox = BaseBox;
BaseBox.displayName = 'BaseBox';
var _default = BaseBox;
exports.default = _default;
var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});