"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _focusRing = _interopRequireDefault(require("@atlaskit/focus-ring"));
var _baseBox = _interopRequireDefault(require("./internal/base-box"));
var _excluded = ["children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "isDisabled", "type", "testId"];
/** @jsx jsx */
var defaultStyles = (0, _react2.css)({
  cursor: 'pointer'
});

/**
 * __Pressable__
 *
 * A Pressable is a primitive component that renders a `<button>`.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
var Pressable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    isDisabled = _ref.isDisabled,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    testId = _ref.testId,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (0, _react2.jsx)(_focusRing.default, null, (0, _react2.jsx)(_baseBox.default, (0, _extends2.default)({}, htmlAttributes, {
    ref: ref,
    testId: testId,
    type: type,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    as: "button",
    css: defaultStyles,
    disabled: isDisabled
  }), children));
});
var _default = Pressable;
exports.default = _default;