"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
var _flex = _interopRequireDefault(require("./flex"));
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */

var flexGrowMap = {
  hug: (0, _xcss.xcss)({
    flexGrow: 0
  }),
  fill: (0, _xcss.xcss)({
    width: '100%',
    flexGrow: 1
  })
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
var Stack = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignInline,
    alignBlock = _ref.alignBlock,
    spread = _ref.spread,
    grow = _ref.grow,
    space = _ref.space,
    children = _ref.children,
    testId = _ref.testId,
    xcss = _ref.xcss;
  var justifyContent = spread || alignBlock;
  return (0, _react2.jsx)(_flex.default, {
    as: as,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: justifyContent,
    xcss: grow ? [flexGrowMap[grow]].concat((0, _toConsumableArray2.default)(Array.isArray(xcss) ? xcss : [xcss])) :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
var _default = Stack;
exports.default = _default;