"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAFE_buildBelowMediaQueryCSS = exports.UNSAFE_buildAboveMediaQueryCSS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _constants = require("./constants");
var _mediaHelper = require("./media-helper");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildAboveMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xxs: css({ '@media all': { display: 'none' } }),
 *   xs: css({ '@media (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
var UNSAFE_buildAboveMediaQueryCSS = function UNSAFE_buildAboveMediaQueryCSS(input) {
  return _constants.UNSAFE_BREAKPOINTS_ORDERED_LIST.reduce(function (acc, breakpoint) {
    return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, breakpoint, (0, _react.css)((0, _defineProperty2.default)({}, _mediaHelper.media.above[breakpoint], typeof input === 'function' ? input(breakpoint) : input))));
  }, {});
};

/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildBelowMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xs: css({ '@media not all and (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media not all and (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
exports.UNSAFE_buildAboveMediaQueryCSS = UNSAFE_buildAboveMediaQueryCSS;
var UNSAFE_buildBelowMediaQueryCSS = function UNSAFE_buildBelowMediaQueryCSS(input) {
  return _constants.UNSAFE_BREAKPOINTS_ORDERED_LIST.reduce(function (acc, breakpoint) {
    if (breakpoint === 'xxs') {
      return acc;
    }
    return _objectSpread(_objectSpread({}, acc), {}, (0, _defineProperty2.default)({}, breakpoint, (0, _react.css)((0, _defineProperty2.default)({}, _mediaHelper.UNSAFE_media.below[breakpoint], typeof input === 'function' ? input(breakpoint) : input))));
  }, {});
};
exports.UNSAFE_buildBelowMediaQueryCSS = UNSAFE_buildBelowMediaQueryCSS;