"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hide = void 0;
var _react = require("@emotion/react");
var _buildMediaQueryCss = require("./build-media-query-css");
/** @jsx jsx */

var hideAboveQueries = (0, _buildMediaQueryCss.UNSAFE_buildAboveMediaQueryCSS)({
  display: 'none'
});
var hideBelowQueries = (0, _buildMediaQueryCss.UNSAFE_buildBelowMediaQueryCSS)({
  display: 'none'
});
/**
 * Hides the content at a given breakpoint.  By default, content is shown.  The primary use case is for visual presentation.
 * Mix `<Hide above="md">` with `<Show above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
var Hide = function Hide(_ref) {
  var above = _ref.above,
    below = _ref.below,
    children = _ref.children,
    _ref$as = _ref.as,
    AsElement = _ref$as === void 0 ? 'div' : _ref$as;
  return (0, _react.jsx)(AsElement, {
    css: [above && hideAboveQueries[above], below && hideBelowQueries[below]]
  }, children);
};
exports.Hide = Hide;