"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Show = void 0;
var _react = require("@emotion/react");
var _buildMediaQueryCss = require("./build-media-query-css");
/** @jsx jsx */

var showAboveQueries = (0, _buildMediaQueryCss.UNSAFE_buildAboveMediaQueryCSS)({
  display: 'revert'
});
var showBelowQueries = (0, _buildMediaQueryCss.UNSAFE_buildBelowMediaQueryCSS)({
  display: 'revert'
});
var defaultHiddenStyles = (0, _react.css)({
  display: 'none'
});
/**
 * Shows the content at a given breakpoint.  By default, content is hidden.  The primary use case is for visual presentation.
 * Mix `<Show above="md">` with `<Hide above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` and `display: revert` to show/hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
var Show = function Show(_ref) {
  var above = _ref.above,
    below = _ref.below,
    children = _ref.children,
    _ref$as = _ref.as,
    AsElement = _ref$as === void 0 ? 'div' : _ref$as;
  return (0, _react.jsx)(AsElement, {
    css: [defaultHiddenStyles, above && showAboveQueries[above], below && showBelowQueries[below]]
  }, children);
};
exports.Show = Show;