import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { forwardRef } from 'react';
import { jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
import { BaseBox } from './internal/base-box';
/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
const Box = /*#__PURE__*/forwardRef(({
  as,
  children,
  backgroundColor,
  padding,
  paddingBlock,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  style,
  testId,
  xcss,
  ...htmlAttributes
}, ref) => {
  const {
    className: spreadClass,
    ...safeHtmlAttributes
  } = htmlAttributes;
  const className = xcss && parseXcss(xcss);
  return jsx(BaseBox, _extends({
    as: as,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    style: style,
    testId: testId,
    ref: ref
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: className
  }, safeHtmlAttributes), children);
});
Box.displayName = 'Box';
export default Box;