/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { spaceStylesMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';
const justifyContentMap = {
  start: css({
    justifyContent: 'start'
  }),
  center: css({
    justifyContent: 'center'
  }),
  end: css({
    justifyContent: 'end'
  }),
  'space-between': css({
    justifyContent: 'space-between'
  }),
  'space-around': css({
    justifyContent: 'space-around'
  }),
  'space-evenly': css({
    justifyContent: 'space-evenly'
  }),
  stretch: css({
    justifyContent: 'stretch'
  })
};
const flexDirectionMap = {
  column: css({
    flexDirection: 'column'
  }),
  row: css({
    flexDirection: 'row'
  })
};
const flexWrapMap = {
  wrap: css({
    flexWrap: 'wrap'
  }),
  nowrap: css({
    flexWrap: 'nowrap'
  })
};
const alignItemsMap = {
  start: css({
    alignItems: 'start'
  }),
  center: css({
    alignItems: 'center'
  }),
  baseline: css({
    alignItems: 'baseline'
  }),
  end: css({
    alignItems: 'end'
  }),
  stretch: css({
    alignItems: 'stretch'
  })
};
const baseStyles = css({
  display: 'flex',
  boxSizing: 'border-box'
});

/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
const Flex = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as: Component = 'div',
  alignItems,
  justifyContent,
  gap,
  columnGap,
  rowGap,
  children,
  testId,
  direction,
  wrap,
  xcss
}, ref) => {
  const xcssClassName = xcss && parseXcss(xcss);
  return jsx(Component, {
    css: [baseStyles, gap && spaceStylesMap.gap[gap], columnGap && spaceStylesMap.columnGap[columnGap], rowGap && spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], direction && flexDirectionMap[direction], justifyContent && justifyContentMap[justifyContent], wrap && flexWrapMap[wrap],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssClassName && xcssClassName],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Flex.displayName = 'Flex';
export default Flex;