/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { spaceStylesMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';
const justifyContentMap = {
  start: css({
    justifyContent: 'start'
  }),
  center: css({
    justifyContent: 'center'
  }),
  end: css({
    justifyContent: 'end'
  }),
  'space-between': css({
    justifyContent: 'space-between'
  }),
  'space-around': css({
    justifyContent: 'space-around'
  }),
  'space-evenly': css({
    justifyContent: 'space-evenly'
  }),
  stretch: css({
    justifyContent: 'stretch'
  })
};
const justifyItemsMap = {
  start: css({
    justifyItems: 'start'
  }),
  center: css({
    justifyItems: 'center'
  }),
  end: css({
    justifyItems: 'end'
  }),
  stretch: css({
    justifyItems: 'stretch'
  })
};
const alignContentMap = {
  start: css({
    alignContent: 'start'
  }),
  center: css({
    alignContent: 'center'
  }),
  end: css({
    alignContent: 'end'
  }),
  'space-between': css({
    alignContent: 'space-between'
  }),
  'space-around': css({
    alignContent: 'space-around'
  }),
  'space-evenly': css({
    alignContent: 'space-evenly'
  }),
  stretch: css({
    alignContent: 'stretch'
  })
};
const alignItemsMap = {
  start: css({
    alignItems: 'start'
  }),
  center: css({
    alignItems: 'center'
  }),
  baseline: css({
    alignItems: 'baseline'
  }),
  end: css({
    alignItems: 'end'
  })
};
const baseStyles = css({
  display: 'grid',
  boxSizing: 'border-box'
});
const gridAutoFlowMap = {
  row: css({
    gridAutoFlow: 'row'
  }),
  column: css({
    gridAutoFlow: 'column'
  }),
  dense: css({
    gridAutoFlow: 'dense'
  }),
  'row dense': css({
    gridAutoFlow: 'row dense'
  }),
  'column dense': css({
    gridAutoFlow: 'column dense'
  })
};

/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
const Grid = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as,
  alignItems,
  alignContent,
  justifyContent,
  gap,
  columnGap,
  rowGap,
  children,
  id,
  role,
  testId,
  autoFlow,
  templateAreas: gridTemplateAreas,
  templateRows: gridTemplateRows,
  templateColumns: gridTemplateColumns,
  xcss
}, ref) => {
  const Component = as || 'div';
  const xcssClassName = xcss && parseXcss(xcss);
  const style = gridTemplateAreas || gridTemplateColumns || gridTemplateRows ? Object.assign({}, {
    gridTemplateAreas: gridTemplateAreas ? gridTemplateAreas.map(str => `"${str}"`).join('\n') : undefined,
    gridTemplateColumns,
    gridTemplateRows
  }) : undefined;
  return jsx(Component, {
    id: id,
    role: role,
    style: style,
    css: [baseStyles, gap && spaceStylesMap.gap[gap], columnGap && spaceStylesMap.columnGap[columnGap], rowGap && spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], alignContent && alignContentMap[alignContent], justifyContent && justifyContentMap[justifyContent], autoFlow && gridAutoFlowMap[autoFlow],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssClassName && xcssClassName],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Grid.displayName = 'Grid';
export default Grid;