/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
import { Children, forwardRef, Fragment, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { xcss } from '../xcss/xcss';
import Flex from './flex';
const flexGrowMap = {
  hug: xcss({
    flexGrow: 0
  }),
  fill: xcss({
    width: '100%',
    flexGrow: 1
  })
};
const separatorStyles = css({
  color: "var(--ds-text-subtle, #42526E)",
  marginBlock: "var(--ds-space-0, 0px)",
  marginInline: `calc(-1 * ${"var(--ds-space-025, 2px)"})`,
  pointerEvents: 'none',
  userSelect: 'none'
});
const Separator = ({
  children
}) => jsx("span", {
  css: separatorStyles
}, children);

/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
const Inline = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as,
  alignInline,
  alignBlock: alignItems = 'start',
  shouldWrap = false,
  spread,
  grow,
  space,
  rowSpace,
  separator,
  xcss,
  testId,
  children: rawChildren
}, ref) => {
  const separatorComponent = typeof separator === 'string' ? jsx(Separator, null, separator) : separator;
  const children = separatorComponent ? Children.toArray(rawChildren).filter(Boolean).map((child, index) => {
    return jsx(Fragment, {
      key: index
    }, separator && index > 0 ? separatorComponent : null, child);
  }) : rawChildren;
  const justifyContent = spread || alignInline;
  return jsx(Flex, {
    as: as,
    alignItems: alignItems,
    justifyContent: justifyContent,
    direction: "row",
    gap: space,
    rowGap: rowSpace,
    wrap: shouldWrap ? 'wrap' : undefined,
    xcss: grow ? [flexGrowMap[grow], ...(Array.isArray(xcss) ? xcss : [xcss])] :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Inline.displayName = 'Inline';
export default Inline;