import _extends from "@babel/runtime/helpers/extends";
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import { backgroundColorStylesMap, paddingStylesMap } from '../../xcss/style-maps.partial';

// Without this type annotation on Box we don't get autocomplete for props due to forwardRef types

/**
 * __Box__
 *
 * Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * @internal
 */
export const BaseBox = /*#__PURE__*/forwardRef(({
  as = 'div',
  className,
  children,
  backgroundColor,
  padding,
  paddingBlock,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  style,
  testId,
  css,
  ...htmlAttributes
}, ref) => {
  const Component = as;
  const node = jsx(Component, _extends({
    style: style,
    ref: ref
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, htmlAttributes, {
    className: className,
    css: [baseStyles, backgroundColor && backgroundColorStylesMap[backgroundColor], padding && paddingStylesMap.padding[padding], paddingBlock && paddingStylesMap.paddingBlock[paddingBlock], paddingBlockStart && paddingStylesMap.paddingBlockStart[paddingBlockStart], paddingBlockEnd && paddingStylesMap.paddingBlockEnd[paddingBlockEnd], paddingInline && paddingStylesMap.paddingInline[paddingInline], paddingInlineStart && paddingStylesMap.paddingInlineStart[paddingInlineStart], paddingInlineEnd && paddingStylesMap.paddingInlineEnd[paddingInlineEnd]],
    "data-testid": testId
  }), children);
  return node;
});
BaseBox.displayName = 'BaseBox';
export default BaseBox;
const baseStyles = css({
  boxSizing: 'border-box',
  appearance: 'none',
  border: 'none'
});