import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import FocusRing from '@atlaskit/focus-ring';
import BaseBox from './internal/base-box';
const defaultStyles = css({
  cursor: 'pointer'
});

/**
 * __Pressable__
 *
 * A Pressable is a primitive component that renders a `<button>`.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
const Pressable = /*#__PURE__*/forwardRef(({
  children,
  backgroundColor,
  padding,
  paddingBlock,
  paddingBlockStart,
  paddingBlockEnd,
  paddingInline,
  paddingInlineStart,
  paddingInlineEnd,
  isDisabled,
  type = 'button',
  testId,
  ...htmlAttributes
}, ref) => {
  return jsx(FocusRing, null, jsx(BaseBox, _extends({}, htmlAttributes, {
    ref: ref,
    testId: testId,
    type: type,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    as: "button",
    css: defaultStyles,
    disabled: isDisabled
  }), children));
});
export default Pressable;