/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { xcss } from '../xcss/xcss';
import Flex from './flex';
const flexGrowMap = {
  hug: xcss({
    flexGrow: 0
  }),
  fill: xcss({
    width: '100%',
    flexGrow: 1
  })
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
const Stack = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as,
  alignInline: alignItems,
  alignBlock,
  spread,
  grow,
  space,
  children,
  testId,
  xcss
}, ref) => {
  const justifyContent = spread || alignBlock;
  return jsx(Flex, {
    as: as,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: justifyContent,
    xcss: grow ? [flexGrowMap[grow], ...(Array.isArray(xcss) ? xcss : [xcss])] :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
export default Stack;