/* eslint-disable @atlaskit/design-system/use-primitives */
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { memo } from 'react';
import { css, jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
var baseStyles = css({
  boxSizing: 'border-box'
});
var blockBleedMap = {
  'space.025': css({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-050, 2px)", ")")
  }),
  'space.050': css({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-050, 4px)", ")")
  }),
  'space.100': css({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-100, 8px)", ")")
  }),
  'space.200': css({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-200, 16px)", ")")
  }),
  'space.150': css({
    marginBlock: "calc(-1 * ".concat("var(--ds-space-150, 12px)", ")")
  })
};
var inlineBleedMap = {
  'space.025': css({
    marginInline: "calc(-1 * ".concat("var(--ds-space-025, 2px)", ")")
  }),
  'space.050': css({
    marginInline: "calc(-1 * ".concat("var(--ds-space-050, 4px)", ")")
  }),
  'space.100': css({
    marginInline: "calc(-1 * ".concat("var(--ds-space-100, 8px)", ")")
  }),
  'space.200': css({
    marginInline: "calc(-1 * ".concat("var(--ds-space-200, 16px)", ")")
  }),
  'space.150': css({
    marginInline: "calc(-1 * ".concat("var(--ds-space-150, 12px)", ")")
  })
};

/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
var Bleed = /*#__PURE__*/memo(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    inline = _ref.inline,
    block = _ref.block,
    all = _ref.all,
    xcss = _ref.xcss;
  var xcssStyles = xcss && parseXcss(xcss);
  return jsx("div", {
    css: [baseStyles, (inline || all) && inlineBleedMap[inline || all], (block || all) && blockBleedMap[block || all],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssStyles],
    "data-testid": testId
  }, children);
});
Bleed.displayName = 'Bleed';
export default Bleed;