import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "style", "testId", "xcss"],
  _excluded2 = ["className"];
/** @jsx jsx */
import { forwardRef } from 'react';
import { jsx } from '@emotion/react';
import { parseXcss } from '../xcss/xcss';
import { BaseBox } from './internal/base-box';
/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
var Box = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var as = _ref.as,
    children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    htmlAttributes = _objectWithoutProperties(_ref, _excluded);
  var spreadClass = htmlAttributes.className,
    safeHtmlAttributes = _objectWithoutProperties(htmlAttributes, _excluded2);
  var className = xcss && parseXcss(xcss);
  return jsx(BaseBox, _extends({
    as: as,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    style: style,
    testId: testId,
    ref: ref
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: className
  }, safeHtmlAttributes), children);
});
Box.displayName = 'Box';
export default Box;