/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { spaceStylesMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';
var justifyContentMap = {
  start: css({
    justifyContent: 'start'
  }),
  center: css({
    justifyContent: 'center'
  }),
  end: css({
    justifyContent: 'end'
  }),
  'space-between': css({
    justifyContent: 'space-between'
  }),
  'space-around': css({
    justifyContent: 'space-around'
  }),
  'space-evenly': css({
    justifyContent: 'space-evenly'
  }),
  stretch: css({
    justifyContent: 'stretch'
  })
};
var flexDirectionMap = {
  column: css({
    flexDirection: 'column'
  }),
  row: css({
    flexDirection: 'row'
  })
};
var flexWrapMap = {
  wrap: css({
    flexWrap: 'wrap'
  }),
  nowrap: css({
    flexWrap: 'nowrap'
  })
};
var alignItemsMap = {
  start: css({
    alignItems: 'start'
  }),
  center: css({
    alignItems: 'center'
  }),
  baseline: css({
    alignItems: 'baseline'
  }),
  end: css({
    alignItems: 'end'
  }),
  stretch: css({
    alignItems: 'stretch'
  })
};
var baseStyles = css({
  display: 'flex',
  boxSizing: 'border-box'
});

/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
var Flex = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'div' : _ref$as,
    alignItems = _ref.alignItems,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    testId = _ref.testId,
    direction = _ref.direction,
    wrap = _ref.wrap,
    xcss = _ref.xcss;
  var xcssClassName = xcss && parseXcss(xcss);
  return jsx(Component, {
    css: [baseStyles, gap && spaceStylesMap.gap[gap], columnGap && spaceStylesMap.columnGap[columnGap], rowGap && spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], direction && flexDirectionMap[direction], justifyContent && justifyContentMap[justifyContent], wrap && flexWrapMap[wrap],
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcssClassName && xcssClassName],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Flex.displayName = 'Flex';
export default Flex;