import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
import { Children, forwardRef, Fragment, memo } from 'react';
import { css, jsx } from '@emotion/react';
import { xcss } from '../xcss/xcss';
import Flex from './flex';
var flexGrowMap = {
  hug: xcss({
    flexGrow: 0
  }),
  fill: xcss({
    width: '100%',
    flexGrow: 1
  })
};
var separatorStyles = css({
  color: "var(--ds-text-subtle, #42526E)",
  marginBlock: "var(--ds-space-0, 0px)",
  marginInline: "calc(-1 * ".concat("var(--ds-space-025, 2px)", ")"),
  pointerEvents: 'none',
  userSelect: 'none'
});
var Separator = function Separator(_ref) {
  var children = _ref.children;
  return jsx("span", {
    css: separatorStyles
  }, children);
};

/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
var Inline = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var as = _ref2.as,
    alignInline = _ref2.alignInline,
    _ref2$alignBlock = _ref2.alignBlock,
    alignItems = _ref2$alignBlock === void 0 ? 'start' : _ref2$alignBlock,
    _ref2$shouldWrap = _ref2.shouldWrap,
    shouldWrap = _ref2$shouldWrap === void 0 ? false : _ref2$shouldWrap,
    spread = _ref2.spread,
    grow = _ref2.grow,
    space = _ref2.space,
    rowSpace = _ref2.rowSpace,
    separator = _ref2.separator,
    xcss = _ref2.xcss,
    testId = _ref2.testId,
    rawChildren = _ref2.children;
  var separatorComponent = typeof separator === 'string' ? jsx(Separator, null, separator) : separator;
  var children = separatorComponent ? Children.toArray(rawChildren).filter(Boolean).map(function (child, index) {
    return jsx(Fragment, {
      key: index
    }, separator && index > 0 ? separatorComponent : null, child);
  }) : rawChildren;
  var justifyContent = spread || alignInline;
  return jsx(Flex, {
    as: as,
    alignItems: alignItems,
    justifyContent: justifyContent,
    direction: "row",
    gap: space,
    rowGap: rowSpace,
    wrap: shouldWrap ? 'wrap' : undefined,
    xcss: grow ? [flexGrowMap[grow]].concat(_toConsumableArray(Array.isArray(xcss) ? xcss : [xcss])) :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Inline.displayName = 'Inline';
export default Inline;