import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "backgroundColor", "padding", "paddingBlock", "paddingBlockStart", "paddingBlockEnd", "paddingInline", "paddingInlineStart", "paddingInlineEnd", "isDisabled", "type", "testId"];
/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import FocusRing from '@atlaskit/focus-ring';
import BaseBox from './internal/base-box';
var defaultStyles = css({
  cursor: 'pointer'
});

/**
 * __Pressable__
 *
 * A Pressable is a primitive component that renders a `<button>`.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
var Pressable = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    backgroundColor = _ref.backgroundColor,
    padding = _ref.padding,
    paddingBlock = _ref.paddingBlock,
    paddingBlockStart = _ref.paddingBlockStart,
    paddingBlockEnd = _ref.paddingBlockEnd,
    paddingInline = _ref.paddingInline,
    paddingInlineStart = _ref.paddingInlineStart,
    paddingInlineEnd = _ref.paddingInlineEnd,
    isDisabled = _ref.isDisabled,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    testId = _ref.testId,
    htmlAttributes = _objectWithoutProperties(_ref, _excluded);
  return jsx(FocusRing, null, jsx(BaseBox, _extends({}, htmlAttributes, {
    ref: ref,
    testId: testId,
    type: type,
    backgroundColor: backgroundColor,
    padding: padding,
    paddingBlock: paddingBlock,
    paddingBlockStart: paddingBlockStart,
    paddingBlockEnd: paddingBlockEnd,
    paddingInline: paddingInline,
    paddingInlineStart: paddingInlineStart,
    paddingInlineEnd: paddingInlineEnd,
    as: "button",
    css: defaultStyles,
    disabled: isDisabled
  }), children));
});
export default Pressable;