import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
/* eslint-disable @repo/internal/styles/no-exported-styles */
/** @jsx jsx */
import { forwardRef, memo } from 'react';
import { jsx } from '@emotion/react';
import { xcss } from '../xcss/xcss';
import Flex from './flex';
var flexGrowMap = {
  hug: xcss({
    flexGrow: 0
  }),
  fill: xcss({
    width: '100%',
    flexGrow: 1
  })
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
var Stack = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignInline,
    alignBlock = _ref.alignBlock,
    spread = _ref.spread,
    grow = _ref.grow,
    space = _ref.space,
    children = _ref.children,
    testId = _ref.testId,
    xcss = _ref.xcss;
  var justifyContent = spread || alignBlock;
  return jsx(Flex, {
    as: as,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: justifyContent,
    xcss: grow ? [flexGrowMap[grow]].concat(_toConsumableArray(Array.isArray(xcss) ? xcss : [xcss])) :
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    xcss,
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
export default Stack;