/** @jsx jsx */
import { ElementType, FC, ReactElement } from 'react';
import { BaseBoxProps } from './internal/base-box';
export type BoxProps<T extends ElementType = 'div'> = Omit<BaseBoxProps<T>, 'className'>;
type BoxComponent<T extends ElementType = 'div'> = (<T extends ElementType = 'div'>(props: BoxProps<T>) => ReactElement | null) & FC<BoxProps<T>>;
/**
 * __Box__
 *
 * A Box is a primitive component that has the design decisions of the Atlassian Design System baked in.
 * Renders a `div` by default.
 *
 * - [Examples](https://atlassian.design/components/primitives/box/examples)
 * - [Code](https://atlassian.design/components/primitives/box/code)
 * - [Usage](https://atlassian.design/components/primitives/box/usage)
 */
declare const Box: BoxComponent;
export default Box;
