/** @jsx jsx */
import { ElementType, ReactNode } from 'react';
import { type Space } from '../xcss/style-maps.partial';
import type { BasePrimitiveProps } from './types';
export type FlexProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Flex. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol' | 'li';
    /**
     * Used to align children along the main axis.
     */
    justifyContent?: JustifyContent;
    /**
     * Used to align children along the cross axis.
     */
    alignItems?: AlignItems;
    /**
     * Represents the space between each child.
     */
    columnGap?: Space;
    /**
     * Represents the space between each child.
     */
    gap?: Space;
    /**
     * Represents the space between each child.
     */
    rowGap?: Space;
    /**
     * Represents the flex direction property of CSS flexbox.
     */
    direction?: Direction;
    /**
     * Represents the flex wrap property of CSS flexbox.
     */
    wrap?: Wrap;
    /**
     * Elements to be rendered inside the Flex.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
export type AlignItems = keyof typeof alignItemsMap;
export type JustifyContent = keyof typeof justifyContentMap;
export type Direction = keyof typeof flexDirectionMap;
export type Wrap = keyof typeof flexWrapMap;
declare const justifyContentMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
    readonly 'space-between': import("@emotion/react").SerializedStyles;
    readonly 'space-around': import("@emotion/react").SerializedStyles;
    readonly 'space-evenly': import("@emotion/react").SerializedStyles;
    readonly stretch: import("@emotion/react").SerializedStyles;
};
declare const flexDirectionMap: {
    readonly column: import("@emotion/react").SerializedStyles;
    readonly row: import("@emotion/react").SerializedStyles;
};
declare const flexWrapMap: {
    readonly wrap: import("@emotion/react").SerializedStyles;
    readonly nowrap: import("@emotion/react").SerializedStyles;
};
declare const alignItemsMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly baseline: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
    readonly stretch: import("@emotion/react").SerializedStyles;
};
/**
 * __Flex__
 *
 * `Flex` is a primitive component that implements the CSS Flexbox API.
 *
 * - [Examples](https://atlassian.design/components/primitives/flex/examples)
 * - [Code](https://atlassian.design/components/primitives/flex/code)
 *
 * @example
 * ```tsx
 * import { Flex, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Flex direction="column">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Flex>
 * )
 * ```
 */
declare const Flex: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Pick<{
    /**
     * The DOM element to render as the Flex. Defaults to `div`.
     */
    as?: "div" | "li" | "ol" | "span" | "ul" | undefined;
    /**
     * Used to align children along the main axis.
     */
    justifyContent?: "space-around" | "space-between" | "space-evenly" | "stretch" | "center" | "end" | "start" | undefined;
    /**
     * Used to align children along the cross axis.
     */
    alignItems?: "stretch" | "center" | "end" | "start" | "baseline" | undefined;
    /**
     * Represents the space between each child.
     */
    columnGap?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Represents the space between each child.
     */
    gap?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Represents the space between each child.
     */
    rowGap?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Represents the flex direction property of CSS flexbox.
     */
    direction?: "column" | "row" | undefined;
    /**
     * Represents the flex wrap property of CSS flexbox.
     */
    wrap?: "nowrap" | "wrap" | undefined;
    /**
     * Elements to be rendered inside the Flex.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: any;
} & BasePrimitiveProps, "gap" | "rowGap" | "columnGap" | "alignItems" | "direction" | "justifyContent" | "as" | "children" | keyof BasePrimitiveProps | "wrap"> & import("react").RefAttributes<any>>>;
export default Flex;
