/** @jsx jsx */
import { ElementType, ReactNode } from 'react';
import { type Space } from '../xcss/style-maps.partial';
import { BasePrimitiveProps } from './types';
export type InlineProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Inline. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol' | 'li';
    /**
     * Used to align children along the main axis.
     */
    alignBlock?: AlignBlock;
    /**
     * Used to align children along the cross axis.
     */
    alignInline?: AlignInline;
    /**
     * Used to set whether children are forced onto one line or will wrap onto multiple lines.
     */
    shouldWrap?: boolean;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: Spread;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow;
    /**
     * Represents the space between each child.
     */
    space?: Space;
    /**
     * Represents the space between rows when content wraps.
     * Used to override the `space` value in between rows.
     */
    rowSpace?: Space;
    /**
     * Renders a separator string between each child.
     */
    separator?: string;
    /**
     * Elements to be rendered inside the Inline.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
export type AlignInline = 'start' | 'center' | 'end';
export type AlignBlock = 'start' | 'center' | 'end' | 'baseline' | 'stretch';
export type Spread = 'space-between';
export type Grow = 'hug' | 'fill';
/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
declare const Inline: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Pick<{
    /**
     * The DOM element to render as the Inline. Defaults to `div`.
     */
    as?: "div" | "li" | "ol" | "span" | "ul" | undefined;
    /**
     * Used to align children along the main axis.
     */
    alignBlock?: AlignBlock | undefined;
    /**
     * Used to align children along the cross axis.
     */
    alignInline?: AlignInline | undefined;
    /**
     * Used to set whether children are forced onto one line or will wrap onto multiple lines.
     */
    shouldWrap?: boolean | undefined;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: "space-between" | undefined;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow | undefined;
    /**
     * Represents the space between each child.
     */
    space?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Represents the space between rows when content wraps.
     * Used to override the `space` value in between rows.
     */
    rowSpace?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Renders a separator string between each child.
     */
    separator?: string | undefined;
    /**
     * Elements to be rendered inside the Inline.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: any;
} & BasePrimitiveProps, "as" | "children" | keyof BasePrimitiveProps | "space" | "separator" | "alignInline" | "alignBlock" | "shouldWrap" | "spread" | "grow" | "rowSpace"> & import("react").RefAttributes<any>>>;
export default Inline;
