/** @jsx jsx */
import { ElementType, ReactNode } from 'react';
import { type Space } from '../xcss/style-maps.partial';
import type { BasePrimitiveProps } from './types';
export type StackProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Stack. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol';
    /**
     * Used to align children along the main axis.
     */
    alignBlock?: AlignBlock;
    /**
     * Used to align children along the cross axis.
     */
    alignInline?: AlignInline;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: Spread;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow;
    /**
     * Represents the space between each child.
     */
    space?: Space;
    /**
     * Elements to be rendered inside the Stack.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
export type AlignInline = 'start' | 'center' | 'end';
export type AlignBlock = 'start' | 'center' | 'end';
export type Spread = 'space-between';
export type Grow = 'hug' | 'fill';
/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
declare const Stack: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Pick<{
    /**
     * The DOM element to render as the Stack. Defaults to `div`.
     */
    as?: "div" | "ol" | "span" | "ul" | undefined;
    /**
     * Used to align children along the main axis.
     */
    alignBlock?: AlignBlock | undefined;
    /**
     * Used to align children along the cross axis.
     */
    alignInline?: AlignInline | undefined;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: "space-between" | undefined;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow | undefined;
    /**
     * Represents the space between each child.
     */
    space?: "space.0" | "space.025" | "space.050" | "space.075" | "space.100" | "space.150" | "space.200" | "space.250" | "space.300" | "space.400" | "space.500" | "space.600" | "space.800" | "space.1000" | undefined;
    /**
     * Elements to be rendered inside the Stack.
     */
    children: ReactNode;
    /**
     * Forwarded ref element
     */
    ref?: any;
} & BasePrimitiveProps, "as" | "children" | keyof BasePrimitiveProps | "space" | "alignInline" | "alignBlock" | "spread" | "grow"> & import("react").RefAttributes<any>>>;
export default Stack;
