/**
 * This is an object of usable media query helpers using our internal breakpoints configuration.
 *
 * @internal This explicitly has and should not be used outside of ADS-owned repos (via sourcegraph); to be removed following an internal deprecation and migration.
 */
export declare const UNSAFE_media: {
    /**
     * A media query to target viewports above the min width of a given breakpoint.
     * Note that `media.above.xs` is redundant and should not be used, but it's included for programatic purposes.
     */
    above: {
        /**
         * `above.xxs` is redundant and no media query should be used, but it's included for programatic purposes…
         */
        readonly xxs: "@media all";
        /**
         * Used for mobile viewports.
         */
        readonly xs: "@media (min-width: 30rem)";
        /**
         * Used for tablet viewports.
         */
        readonly sm: "@media (min-width: 48rem)";
        /**
         * Used for laptop viewports.
         */
        readonly md: "@media (min-width: 64rem)";
        /**
         * Used for desktop viewports.
         */
        readonly lg: "@media (min-width: 90rem)";
        /**
         * Used for wide screen desktop viewports.
         */
        readonly xl: "@media (min-width: 110rem)";
    };
    /**
     * A media query to target viewports below the min width of a given breakpoint.  We do this by testing the inverse, eg. below = not above…
     *
     * NOTE: `below.xxs` is intentionally not included as it could lead to incorrect usages as it's never accessible as this would be `xxs: '@media not all',`
     *
     * We use this syntax as a more compatible way to ensure media queries do not overlap, eg. `media.above.md` and `media.below.md` should not both trigger at once.
     * This is well describe in this: @see https://stackoverflow.com/a/13649011
     *
     * Ideally we would use media queries level 4 to improve this interface, but this works and browser support might not be sufficient yet: @see https://www.w3.org/TR/mediaqueries-4/
     *
     * @internal Not intended to be used outside of DST at this stage.
     * @experimental Not intended to be used outside of DST at this stage.
     */
    below: {
        readonly xs: "@media not all and (min-width: 30rem)";
        readonly sm: "@media not all and (min-width: 48rem)";
        readonly md: "@media not all and (min-width: 64rem)";
        readonly lg: "@media not all and (min-width: 90rem)";
        readonly xl: "@media not all and (min-width: 110rem)";
    };
    /**
     * A media query to target viewports exactly between the min and max of a given breakpoint.
     * Ideally we would use media queries level 4 to improve this interface, but this works and browser support might not be sufficient yet: @see https://www.w3.org/TR/mediaqueries-4/
     *
     * @internal Not intended to be used outside of DST at this stage.
     * @experimental Not intended to be used outside of DST at this stage.
     */
    only: {
        readonly xxs: "@media (min-width: 0rem) and (max-width: 29.99rem)";
        readonly xs: "@media (min-width: 30rem) and (max-width: 47.99rem)";
        readonly sm: "@media (min-width: 48rem) and (max-width: 63.99rem)";
        readonly md: "@media (min-width: 64rem) and (max-width: 89.99rem)";
        readonly lg: "@media (min-width: 90rem) and (max-width: 109.99rem)";
        readonly xl: "@media (min-width: 110rem)";
    };
};
/**
 * This is an object of usable media query helpers using our internal breakpoints configuration.
 *
 * We strictly only export `media.above` at this stage as we want makers to build mobile-first.
 */
export declare const media: {
    readonly above: {
        /**
         * `above.xxs` is redundant and no media query should be used, but it's included for programatic purposes…
         */
        readonly xxs: "@media all";
        /**
         * Used for mobile viewports.
         */
        readonly xs: "@media (min-width: 30rem)";
        /**
         * Used for tablet viewports.
         */
        readonly sm: "@media (min-width: 48rem)";
        /**
         * Used for laptop viewports.
         */
        readonly md: "@media (min-width: 64rem)";
        /**
         * Used for desktop viewports.
         */
        readonly lg: "@media (min-width: 90rem)";
        /**
         * Used for wide screen desktop viewports.
         */
        readonly xl: "@media (min-width: 110rem)";
    };
};
