/// <reference types="react" />
import { css as cssEmotion } from '@emotion/react';
import type { CSSPropertiesWithMultiValues, SerializedStyles } from '@emotion/serialize';
import type * as CSS from 'csstype';
import { Box } from '../index';
import type { MediaQuery } from '../responsive/types';
import { TokenisedProps } from './style-maps.partial';
declare const uniqueSymbol: unique symbol;
/**
 * @internal used in primitives
 * @returns a collection of styles that can be applied to the respective primitive
 */
type ParsedXcss = ReturnType<typeof cssEmotion> | ReturnType<typeof cssEmotion>[];
export declare const parseXcss: (args: XCSS | XCSSArray) => ParsedXcss;
type CSSMediaQueries = {
    [MQ in MediaQuery]?: Omit<SafeCSSObject, MediaQuery>;
};
type CSSPseudos = {
    [Pseudo in CSS.Pseudos]?: Omit<SafeCSSObject, CSS.Pseudos | MediaQuery>;
};
type SafeCSSObject = CSSPseudos & TokenisedProps & CSSMediaQueries & Omit<CSSPropertiesWithMultiValues, keyof TokenisedProps>;
type ScopedSafeCSSObject<T extends keyof SafeCSSObject> = Pick<SafeCSSObject, T>;
declare const boxWrapper: (style: any) => {
    readonly [uniqueSymbol]: BoxStyles;
};
declare const spaceWrapper: (style: any) => {
    readonly [uniqueSymbol]: SpaceStyles;
};
type XCSS = ReturnType<typeof boxWrapper> | ReturnType<typeof spaceWrapper>;
type XCSSArray = Array<XCSS | false | undefined>;
type AllowedBoxStyles = keyof SafeCSSObject;
type Spacing = 'columnGap' | 'gap' | 'inset' | 'insetBlock' | 'insetBlockEnd' | 'insetBlockStart' | 'insetInline' | 'insetInlineEnd' | 'insetInlineStart' | 'margin' | 'marginBlock' | 'marginBlockEnd' | 'marginBlockStart' | 'marginInline' | 'marginInlineEnd' | 'marginInlineStart' | 'outlineOffset' | 'padding' | 'paddingBlock' | 'paddingBlockEnd' | 'paddingBlockStart' | 'paddingBottom' | 'paddingInline' | 'paddingInlineEnd' | 'paddingInlineStart' | 'paddingLeft' | 'paddingRight' | 'paddingTop' | 'rowGap';
/**
 * ### xcss
 *
 * `xcss` is a safer, tokens-first approach to CSS-in-JS. It allows token-backed values for
 * CSS application.
 *
 * ```tsx
 * const styles = xcss({
 *   padding: 'space.100'
 * })
 * ```
 */
export declare function xcss<Primitive extends typeof Box | void = typeof Box>(style: Primitive extends typeof Box ? ScopedSafeCSSObject<AllowedBoxStyles> | ScopedSafeCSSObject<AllowedBoxStyles>[] : Primitive extends void ? ScopedSafeCSSObject<Spacing> | ScopedSafeCSSObject<Spacing>[] : never): {
    readonly [uniqueSymbol]: Primitive extends (<T extends import("react").ElementType<any> = "div">(props: import("../index").BoxProps<T>) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>> | null) & import("react").FC<import("../index").BoxProps<"div">> ? BoxStyles : Primitive extends void ? SpaceStyles : never;
};
declare const boxTag: unique symbol;
declare const spaceTag: unique symbol;
export type BoxStyles = SerializedStyles & {
    [boxTag]: true;
};
export type SpaceStyles = SerializedStyles & {
    [spaceTag]: true;
};
export type BoxXCSS = {
    readonly [uniqueSymbol]: BoxStyles;
} | false | undefined;
export {};
