/** @jsx jsx */
import { type ReactElement, type ReactNode } from 'react';
import { type BaseBoxProps } from './internal/base-box';
export type PressableProps = Omit<BaseBoxProps<'button'>, 'disabled' | 'as' | 'children' | 'role' | 'style'> & {
    /**
     * `children` should be defined to ensure buttons are not empty,
     * because they should have labels.
     */
    children: ReactNode;
    isDisabled?: boolean;
};
type PressableComponent = (props: PressableProps, displayName: string) => ReactElement | null;
/**
 * __Pressable__
 *
 * A Pressable is a primitive component that renders a `<button>`.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
declare const Pressable: PressableComponent;
export default Pressable;
