import { CSSObject } from '@emotion/react';
import type { Breakpoint } from './types';
/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildAboveMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xxs: css({ '@media all': { display: 'none' } }),
 *   xs: css({ '@media (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
export declare const UNSAFE_buildAboveMediaQueryCSS: (input: CSSObject | ((breakpoint: Breakpoint) => CSSObject)) => Required<Partial<Record<Breakpoint, import("@emotion/react").SerializedStyles>>>;
/**
 * Build a map of breakpoints to css with media queries and nested styles.
 *
 * @internal Not intended to be used outside of DST at this stage.
 * @experimental Not intended to be used outside of DST at this stage.
 *
 * @example
 * A map to build optional `display:none` for consumption on a div.
 * ```ts
 * const hideMediaQueries = buildBelowMediaQueryCSS({ display: 'none' });
 *
 * const Component = ({ hideAtBreakpoints: ('xs' | 'sm')[], children: ReactNode }) => {
 *   return <div css={hideAtBreakpoints.map(b => hideMediaQueries[b])}>{children}</div>;
 * }
 * ```
 *
 * This roughly builds a map that will look roughly like this (if done manually):
 * ```ts
 * {
 *   xs: css({ '@media not all and (min-width: 30rem)': { display: 'none' } }),
 *   sm: css({ '@media not all and (min-width: 48rem)': { display: 'none' } }),
 * }
 * ```
 */
export declare const UNSAFE_buildBelowMediaQueryCSS: (input: CSSObject | ((breakpoint: Breakpoint) => CSSObject)) => Required<Partial<Record<Breakpoint, import("@emotion/react").SerializedStyles>>>;
