"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _countries = require("./data/countries");
var _Select = _interopRequireDefault(require("./Select"));
/** @jsx jsx */

// custom option renderer
var labelStyles = (0, _react.css)({
  alignItems: 'center',
  display: 'flex',
  lineHeight: 1.2
});
var flagStyles = (0, _react.css)({
  fontSize: '18px',
  marginRight: "var(--ds-space-100, 8px)"
});
var Opt = function Opt(_ref) {
  var children = _ref.children,
    icon = _ref.icon;
  return (0, _react.jsx)("div", {
    css: labelStyles
  }, (0, _react.jsx)("span", {
    css: flagStyles
  }, icon), children);
};

// return the country name; used for searching
var getOptionLabel = function getOptionLabel(_ref2) {
  var abbr = _ref2.abbr,
    code = _ref2.code,
    name = _ref2.name;
  return "".concat(name, " (").concat(abbr.toUpperCase(), ") +").concat(code);
};

// set the country's abbreviation for the option value, (also searchable)
var getOptionValue = function getOptionValue(opt) {
  return opt.abbr;
};

// the text node of the control
var controlLabel = function controlLabel(opt) {
  return (0, _react.jsx)(Opt, {
    icon: opt.icon
  }, opt.abbr.toUpperCase());
};
// the text node for an option
var optionLabel = function optionLabel(_ref3) {
  var abbr = _ref3.abbr,
    code = _ref3.code,
    icon = _ref3.icon,
    name = _ref3.name;
  return (0, _react.jsx)(Opt, {
    icon: icon
  }, getOptionLabel({
    abbr: abbr,
    code: code,
    name: name
  }));
};

// switch formatters based on render context (menu | value)
var formatOptionLabel = function formatOptionLabel(opt, _ref4) {
  var context = _ref4.context;
  return context === 'value' ? controlLabel(opt) : optionLabel(opt);
};

// put it all together
var CountrySelect = function CountrySelect(props) {
  return (0, _react.jsx)(_Select.default, (0, _extends2.default)({
    isClearable: false,
    formatOptionLabel: formatOptionLabel,
    getOptionLabel: getOptionLabel,
    getOptionValue: getOptionValue,
    isMulti: false,
    options: _countries.groupedCountries
  }, props));
};
var _default = CountrySelect;
exports.default = _default;