"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultComponents = exports.MenuDialog = exports.DummyControl = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _reactSelect = require("react-select");
var _react = require("@emotion/react");
var _visuallyHidden = _interopRequireDefault(require("@atlaskit/visually-hidden"));
var _search = _interopRequireDefault(require("@atlaskit/icon/glyph/editor/search"));
var _constants = require("@atlaskit/theme/constants");
var _colors = require("@atlaskit/theme/colors");
var _excluded = ["innerRef", "innerProps"],
  _excluded2 = ["children", "innerProps"];
/** @jsx jsx */
// ==============================
// Styled Components
// ==============================

var MenuDialog = function MenuDialog(_ref) {
  var maxWidth = _ref.maxWidth,
    minWidth = _ref.minWidth,
    children = _ref.children,
    id = _ref.id,
    style = _ref.style;
  return (0, _react.jsx)("div", {
    css: {
      backgroundColor: "var(--ds-surface-overlay, white)",
      borderRadius: 4,
      boxShadow: "var(--ds-shadow-overlay, ".concat("0 0 0 1px ".concat(_colors.N40A, ", 0 4px 11px ").concat(_colors.N40A), ")"),
      maxWidth: maxWidth,
      minWidth: minWidth,
      zIndex: _constants.layers.modal()
    },
    style: style,
    id: id
  }, children);
};

// ==============================
// Custom Components
// ==============================
exports.MenuDialog = MenuDialog;
var DropdownIndicator = function DropdownIndicator() {
  return (0, _react.jsx)("div", {
    css: {
      marginRight: "var(--ds-space-025, 2px)",
      textAlign: 'center',
      width: 32
    }
  }, (0, _react.jsx)(_search.default, {
    label: "open"
  }));
};
var Control = function Control(_ref2) {
  var innerRef = _ref2.innerRef,
    innerProps = _ref2.innerProps,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  return (0, _react.jsx)("div", {
    ref: innerRef,
    css: {
      padding: "var(--ds-space-100, 8px)".concat(" ", "var(--ds-space-100, 8px)", " ", "var(--ds-space-050, 4px)")
    }
  }, (0, _react.jsx)(_reactSelect.components.Control, (0, _extends2.default)({}, props, {
    innerProps: innerProps
  })));
};
var DummyControl = function DummyControl(props) {
  return (0, _react.jsx)(_visuallyHidden.default, null, (0, _react.jsx)(_reactSelect.components.Control, props));
};

// NOTE `props` intentionally omitted from `Fragment`
// eslint-disable-next-line
exports.DummyControl = DummyControl;
var Menu = function Menu(_ref3) {
  var children = _ref3.children,
    innerProps = _ref3.innerProps,
    props = (0, _objectWithoutProperties2.default)(_ref3, _excluded2);
  return (0, _react.jsx)("div", innerProps, children);
};
var defaultComponents = {
  Control: Control,
  DropdownIndicator: DropdownIndicator,
  Menu: Menu
};
exports.defaultComponents = defaultComponents;