"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingIndicator = exports.DropdownIndicator = exports.ClearIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _reactSelect = require("react-select");
var _spinner = _interopRequireDefault(require("@atlaskit/spinner"));
var _selectClear = _interopRequireDefault(require("@atlaskit/icon/glyph/select-clear"));
var _chevronDown = _interopRequireDefault(require("@atlaskit/icon/glyph/chevron-down"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var iconContainerStyles = (0, _react.css)({
  all: 'unset',
  outline: 'revert',
  display: 'flex',
  alignItems: 'center'
});
var ClearIndicator = function ClearIndicator(props) {
  return (0, _react.jsx)(_reactSelect.components.ClearIndicator, _objectSpread(_objectSpread({}, props), {}, {
    innerProps: _objectSpread(_objectSpread({}, props.innerProps), {}, {
      'aria-hidden': 'false'
    })
  }), (0, _react.jsx)("button", {
    css: iconContainerStyles,
    type: "button",
    tabIndex: -1
  }, (0, _react.jsx)(_selectClear.default, {
    size: "small",
    label: "clear"
  })));
};
exports.ClearIndicator = ClearIndicator;
var DropdownIndicator = function DropdownIndicator(props) {
  return (0, _react.jsx)(_reactSelect.components.DropdownIndicator, props, (0, _react.jsx)(_chevronDown.default, {
    label: "open"
  }));
};
exports.DropdownIndicator = DropdownIndicator;
var LoadingIndicator = function LoadingIndicator(props) {
  var loadingCSS = (0, _react.css)(props.getStyles('loadingIndicator', props));
  return (0, _react.jsx)("div", (0, _extends2.default)({
    css: loadingCSS
  }, props.innerProps), (0, _react.jsx)(_spinner.default, {
    size: "small"
  }));
};
exports.LoadingIndicator = LoadingIndicator;