"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadioOption = exports.CheckboxOption = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _react2 = require("react");
var _radio = _interopRequireDefault(require("@atlaskit/icon/glyph/radio"));
var _checkbox = _interopRequireDefault(require("@atlaskit/icon/glyph/checkbox"));
var _components = require("@atlaskit/theme/components");
var _colors = require("@atlaskit/theme/colors");
var _excluded = ["isActive", "isDisabled", "isFocused", "isSelected"],
  _excluded2 = ["isActive", "isDisabled", "isSelected"],
  _excluded3 = ["isActive", "isDisabled", "isFocused", "isSelected"],
  _excluded4 = ["getStyles", "Icon", "children", "innerProps", "innerRef"];
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var getPrimitiveStyles = function getPrimitiveStyles(props) {
  var cx = props.cx,
    className = props.className,
    getStyles = props.getStyles,
    isDisabled = props.isDisabled,
    isFocused = props.isFocused,
    isSelected = props.isSelected;
  var styles = {
    alignItems: 'center',
    backgroundColor: isFocused ? "var(--ds-background-neutral-subtle-hovered, ".concat(_colors.N20, ")") : 'transparent',
    color: isDisabled ? "var(--ds-text-disabled, inherit)" : 'inherit',
    display: 'flex ',
    paddingBottom: "var(--ds-space-050, 4px)",
    paddingLeft: "var(--ds-space-200, 16px)",
    paddingTop: "var(--ds-space-050, 4px)",
    boxShadow: isFocused ? "inset 2px 0px 0px ".concat("var(--ds-border-focused, ".concat(_colors.B400, ")"), ";") : '',
    ':active': {
      backgroundColor: "var(--ds-background-neutral-subtle-pressed, ".concat(_colors.N30, ")")
    },
    '@media screen and (-ms-high-contrast: active)': {
      borderLeft: isFocused ? '2px solid transparent' : ''
    }
  };
  var augmentedStyles = _objectSpread(_objectSpread({}, getStyles('option', props)), styles);
  var bemClasses = {
    option: true,
    'option--is-disabled': isDisabled,
    'option--is-focused': isFocused,
    'option--is-selected': isSelected
  };

  // maintain react-select API
  return [augmentedStyles, cx(bemClasses, className)];
};

// maintains function shape
var backgroundColor = (0, _components.themed)({
  light: "var(--ds-background-neutral, ".concat(_colors.N0, ")"),
  dark: "var(--ds-background-neutral, ".concat(_colors.DN10, ")")
});
var transparent = (0, _components.themed)({
  light: 'transparent',
  dark: 'transparent'
});

// state of the parent option

// the primary color represents the outer or background element
var getPrimaryColor = function getPrimaryColor(_ref) {
  var isActive = _ref.isActive,
    isDisabled = _ref.isDisabled,
    isFocused = _ref.isFocused,
    isSelected = _ref.isSelected,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var color = backgroundColor;
  if (isDisabled && isSelected) {
    color = (0, _components.themed)({
      light: "var(--ds-background-disabled, ".concat(_colors.B75, ")"),
      dark: "var(--ds-background-disabled, ".concat(_colors.DN200, ")")
    });
  } else if (isDisabled) {
    color = (0, _components.themed)({
      light: "var(--ds-background-disabled, ".concat(_colors.N20A, ")"),
      dark: "var(--ds-background-disabled, ".concat(_colors.DN10, ")")
    });
  } else if (isSelected && isActive) {
    color = (0, _components.themed)({
      light: "var(--ds-background-selected-bold-pressed, ".concat(_colors.B75, ")"),
      dark: "var(--ds-background-selected-bold-pressed, ".concat(_colors.B200, ")")
    });
  } else if (isActive) {
    color = (0, _components.themed)({
      light: "var(--ds-background-selected-pressed, ".concat(_colors.B75, ")"),
      dark: "var(--ds-background-selected-pressed, ".concat(_colors.B200, ")")
    });
  } else if (isFocused && isSelected) {
    color = (0, _components.themed)({
      light: "var(--ds-background-selected-bold-hovered, ".concat(_colors.B300, ")"),
      dark: "var(--ds-background-selected-bold-hovered, ".concat(_colors.B75, ")")
    });
  } else if (isFocused) {
    color = (0, _components.themed)({
      light: "var(--ds-surface, ".concat(_colors.N0, ")"),
      dark: "var(--ds-surface, ".concat(_colors.DN30, ")")
    });
  } else if (isSelected) {
    color = (0, _components.themed)({
      light: "var(--ds-background-selected-bold, ".concat(_colors.B400, ")"),
      dark: "var(--ds-background-selected-bold, ".concat(_colors.B100, ")")
    });
  }
  return color(rest);
};

// the secondary color represents the radio dot or checkmark
var getSecondaryColor = function getSecondaryColor(_ref2) {
  var isActive = _ref2.isActive,
    isDisabled = _ref2.isDisabled,
    isSelected = _ref2.isSelected,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var color = (0, _components.themed)({
    light: "var(--ds-surface, ".concat(_colors.N0, ")"),
    dark: "var(--ds-surface, ".concat(_colors.DN10, ")")
  });
  if (isDisabled && isSelected) {
    color = (0, _components.themed)({
      light: "var(--ds-text-disabled, ".concat(_colors.N70, ")"),
      dark: "var(--ds-text-disabled, ".concat(_colors.DN10, ")")
    });
  } else if (isActive && isSelected && !isDisabled) {
    color = (0, _components.themed)({
      light: "var(--ds-surface, ".concat(_colors.B400, ")"),
      dark: "var(--ds-surface, ".concat(_colors.DN10, ")")
    });
  } else if (!isSelected) {
    color = transparent;
  }
  return color(rest);
};

// the border color surrounds the checkbox/radio
var getBorderColor = function getBorderColor(_ref3) {
  var isActive = _ref3.isActive,
    isDisabled = _ref3.isDisabled,
    isFocused = _ref3.isFocused,
    isSelected = _ref3.isSelected,
    rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
  if (isDisabled && isSelected) {
    return "var(--ds-background-disabled, ".concat(_colors.B400, ")");
  } else if (isDisabled) {
    return "var(--ds-background-disabled, ".concat(_colors.N100, ")");
  } else if (isSelected && isActive) {
    return "var(--ds-background-selected-bold-pressed, ".concat(_colors.B400, ")");
  } else if (isActive) {
    return "var(--ds-background-selected-bold, ".concat(_colors.B400, ")");
  } else if (isFocused && isSelected) {
    return "var(--ds-background-selected-bold-hovered, ".concat(_colors.B400, ")");
  } else if (isFocused) {
    return "var(--ds-border-input, ".concat(_colors.N100, ")");
  } else if (isSelected) {
    return "var(--ds-background-selected-bold, ".concat(_colors.B400, ")");
  }
  return "var(--ds-border-input, ".concat(_colors.N100, ")");
};
var ControlOption = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ControlOption, _Component);
  var _super = _createSuper(ControlOption);
  function ControlOption() {
    var _this;
    (0, _classCallCheck2.default)(this, ControlOption);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isActive: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseDown", function () {
      return _this.setState({
        isActive: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseUp", function () {
      return _this.setState({
        isActive: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMouseLeave", function () {
      return _this.setState({
        isActive: false
      });
    });
    return _this;
  }
  (0, _createClass2.default)(ControlOption, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        getStyles = _this$props.getStyles,
        Icon = _this$props.Icon,
        children = _this$props.children,
        innerProps = _this$props.innerProps,
        innerRef = _this$props.innerRef,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded4);

      // prop assignment
      var props = _objectSpread(_objectSpread({}, innerProps), {}, {
        onMouseDown: this.onMouseDown,
        onMouseUp: this.onMouseUp,
        onMouseLeave: this.onMouseLeave
      });
      var _getPrimitiveStyles = getPrimitiveStyles(_objectSpread({
          getStyles: getStyles
        }, rest)),
        _getPrimitiveStyles2 = (0, _slicedToArray2.default)(_getPrimitiveStyles, 2),
        styles = _getPrimitiveStyles2[0],
        classes = _getPrimitiveStyles2[1];
      return (
        /**
         * TODO Fix this type error
         * @see https://product-fabric.atlassian.net/browse/DSP-6063
         */
        // @ts-ignore
        (0, _react.jsx)("div", (0, _extends2.default)({
          css: styles,
          className: classes,
          ref: innerRef
        }, props), (0, _react.jsx)("div", {
          css: {
            alignItems: 'center',
            display: 'flex ',
            flexShrink: 0,
            paddingRight: "var(--ds-space-050, 4px)",
            // Here we are adding a border to the Checkbox and Radio SVG icons
            // This is an a11y fix for Select only for now but it may be rolled
            // into the `@atlaskit/icon` package's Checkbox and Radio SVGs later
            '& svg rect, & svg circle:first-of-type': {
              stroke: getBorderColor(_objectSpread(_objectSpread({}, this.props), this.state)),
              strokeWidth: '2px',
              strokeLinejoin: 'round'
            }
          }
        }, !!Icon ? (0, _react.jsx)(Icon, {
          label: "",
          primaryColor: getPrimaryColor(_objectSpread(_objectSpread({}, this.props), this.state)),
          secondaryColor: getSecondaryColor(_objectSpread(_objectSpread({}, this.props), this.state))
        }) : null), (0, _react.jsx)("div", {
          css: {
            textOverflow: 'ellipsis',
            overflowX: 'hidden',
            flexGrow: 1,
            whiteSpace: 'nowrap'
          }
        }, children))
      );
    }
  }]);
  return ControlOption;
}(_react2.Component);
var CheckboxOption = function CheckboxOption(props) {
  return (0, _react.jsx)(ControlOption, (0, _extends2.default)({
    Icon: _checkbox.default
  }, props));
};
exports.CheckboxOption = CheckboxOption;
var RadioOption = function RadioOption(props) {
  return (0, _react.jsx)(ControlOption, (0, _extends2.default)({
    Icon: _radio.default
  }, props));
};
exports.RadioOption = RadioOption;