"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = baseStyles;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@atlaskit/theme/constants");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _colors = require("@atlaskit/theme/colors");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } // eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
var BORDER_WIDTH = 2;
var ICON_PADDING = 2;
var paddingExcludingBorder = (0, _constants.gridSize)() - BORDER_WIDTH;
function baseStyles(validationState) {
  var isCompact = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var appearance = arguments.length > 2 ? arguments[2] : undefined;
  return {
    container: function container(css, _ref) {
      var isDisabled = _ref.isDisabled;
      return _objectSpread(_objectSpread({}, css), {}, {
        fontFamily: "var(--ds-font-family-sans, ".concat((0, _constants.fontFamily)(), ")"),
        // react-select disables pointer events when isDisabled is true.
        // We override this and make the inner container turn it off instead.
        pointerEvents: 'all',
        cursor: isDisabled ? 'not-allowed' : css.cursor
      });
    },
    input: function input(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        color: "var(--ds-text, hsl(0, 0%, 20%))"
      });
    },
    control: function control(css, _ref2) {
      var isFocused = _ref2.isFocused,
        isDisabled = _ref2.isDisabled;
      var borderColor = isFocused ? "var(--ds-border-focused, ".concat(_colors.B100, ")") : "var(--ds-border-input, ".concat((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? _colors.N100 : _colors.N20, ")");
      var backgroundColor = isFocused ? "var(--ds-background-input-pressed, ".concat(_colors.N0, ")") : "var(--ds-background-input, ".concat(_colors.N20, ")");
      var backgroundColorHover = isFocused ? "var(--ds-background-input-pressed, ".concat(_colors.N0, ")") : "var(--ds-background-input-hovered, ".concat(_colors.N30, ")");
      if (isDisabled) {
        backgroundColor = "var(--ds-background-disabled, ".concat(_colors.N20, ")");
        borderColor = "var(--ds-background-disabled, ".concat(_colors.N20, ")");
      }
      if (validationState === 'error') {
        borderColor = "var(--ds-border-danger, ".concat(_colors.R400, ")");
      }
      if (validationState === 'success') {
        borderColor = "var(--ds-border-success, ".concat(_colors.G400, ")");
      }
      var borderColorHover = isFocused ? "var(--ds-border-focused, ".concat(_colors.B100, ")") : "var(--ds-border-input, ".concat((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? _colors.N100 : _colors.N30, ")");
      if (validationState === 'error') {
        borderColorHover = "var(--ds-border-danger, ".concat(_colors.R400, ")");
      }
      if (validationState === 'success') {
        borderColorHover = "var(--ds-border-success, ".concat(_colors.G400, ")");
      }
      var transitionDuration = '200ms';
      if (appearance === 'subtle') {
        borderColor = isFocused ? "var(--ds-border-focused, ".concat(_colors.B100, ")") : 'transparent';
        backgroundColor = isFocused ? "var(--ds-surface, ".concat(_colors.N0, ")") : 'transparent';
        backgroundColorHover = isFocused ? "var(--ds-background-input-pressed, ".concat(_colors.N0, ")") : "var(--ds-background-input-hovered, ".concat(_colors.N30, ")");
      }
      if (appearance === 'none') {
        borderColor = 'transparent';
        backgroundColor = 'transparent';
        backgroundColorHover = 'transparent';
        borderColorHover = 'transparent';
      }
      return _objectSpread(_objectSpread(_objectSpread({}, css), {}, {
        // Turn pointer events off when disabled - this makes it so hover etc don't work.
        pointerEvents: isDisabled ? 'none' : undefined,
        backgroundColor: backgroundColor,
        borderColor: borderColor,
        borderStyle: 'solid',
        borderRadius: "var(--ds-border-radius-100, 3px)",
        borderWidth: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "var(--ds-border-width, 1px)" : "var(--ds-border-width-outline, 2px)",
        boxShadow: 'none'
      }, (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') && {
        '&:focus-within': {
          boxShadow: "inset 0 0 0 ".concat("var(--ds-border-width, 1px)", " ", borderColor)
        }
      }), {}, {
        minHeight: isCompact ? (0, _constants.gridSize)() * 4 : (0, _constants.gridSize)() * 5,
        padding: 0,
        transition: "background-color ".concat(transitionDuration, " ease-in-out,\n        border-color ").concat(transitionDuration, " ease-in-out"),
        '::-webkit-scrollbar': {
          height: (0, _constants.gridSize)(),
          width: (0, _constants.gridSize)()
        },
        '::-webkit-scrollbar-corner': {
          display: 'none'
        },
        ':hover': {
          '::-webkit-scrollbar-thumb': {
            // scrollbars occur only if the user passes in a custom component with overflow: scroll
            // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
            backgroundColor: 'rgba(0,0,0,0.2)'
          },
          cursor: 'pointer',
          backgroundColor: backgroundColorHover,
          borderColor: borderColorHover
        },
        '::-webkit-scrollbar-thumb:hover': {
          // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
          backgroundColor: 'rgba(0,0,0,0.4)'
        }
      });
    },
    valueContainer: function valueContainer(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        paddingLeft: paddingExcludingBorder,
        paddingRight: paddingExcludingBorder,
        paddingBottom: isCompact ? 0 : 2,
        paddingTop: isCompact ? 0 : 2
      });
    },
    clearIndicator: function clearIndicator(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        color: "var(--ds-text-subtlest, ".concat(_colors.N70, ")"),
        paddingLeft: ICON_PADDING,
        paddingRight: ICON_PADDING,
        paddingBottom: isCompact ? 0 : 6,
        paddingTop: isCompact ? 0 : 6,
        ':hover': {
          color: "var(--ds-text-subtle, ".concat(_colors.N500, ")")
        }
      });
    },
    loadingIndicator: function loadingIndicator(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        paddingBottom: isCompact ? 0 : 6,
        paddingTop: isCompact ? 0 : 6
      });
    },
    dropdownIndicator: function dropdownIndicator(css, _ref3) {
      var isDisabled = _ref3.isDisabled;
      var color = "var(--ds-text-subtle, ".concat(_colors.N500, ")");
      if (isDisabled) {
        color = "var(--ds-text-disabled, ".concat(_colors.N70, ")");
      }
      return _objectSpread(_objectSpread({}, css), {}, {
        color: color,
        paddingLeft: ICON_PADDING,
        paddingRight: ICON_PADDING,
        paddingBottom: isCompact ? 0 : 6,
        paddingTop: isCompact ? 0 : 6,
        ':hover': {
          color: "var(--ds-text-subtle, ".concat(_colors.N200, ")")
        }
      });
    },
    indicatorsContainer: function indicatorsContainer(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        paddingRight: paddingExcludingBorder - ICON_PADDING
      });
    },
    option: function option(css, _ref4) {
      var isFocused = _ref4.isFocused,
        isSelected = _ref4.isSelected,
        isDisabled = _ref4.isDisabled;
      var color = "var(--ds-text, ".concat(_colors.N800, ")");
      if (isDisabled) {
        color = "var(--ds-text-disabled, ".concat(_colors.N70, ")");
      } else if (isSelected) {
        color = "var(--ds-text-selected, ".concat(_colors.B400, ")");
      }
      var boxShadow;
      var backgroundColor;
      if (isDisabled) {
        backgroundColor = undefined;
      } else if (isSelected && isFocused) {
        backgroundColor = "var(--ds-background-selected-hovered, ".concat(_colors.B50, ")");
      } else if (isSelected) {
        backgroundColor = "var(--ds-background-selected, ".concat(_colors.B50, ")");
      } else if (isFocused) {
        backgroundColor = "var(--ds-background-neutral-subtle-hovered, ".concat(_colors.N20, ")");
      }
      if (!isDisabled && (isFocused || isSelected)) {
        boxShadow = "inset 2px 0px 0px ".concat("var(--ds-border-selected, ".concat(_colors.B400, ")"));
      }
      var cursor = isDisabled ? 'not-allowed' : css.cursor;
      return _objectSpread(_objectSpread({}, css), {}, {
        padding: '6px 12px',
        backgroundColor: backgroundColor,
        color: color,
        cursor: cursor,
        boxShadow: boxShadow,
        ':active': {
          backgroundColor: !isDisabled ? isSelected ? "var(--ds-background-selected-pressed, ".concat(_colors.N20, ")") : "var(--ds-background-neutral-subtle-pressed, ".concat(_colors.N30, ")") : undefined
        },
        '@media screen and (-ms-high-contrast: active)': {
          borderLeft: !isDisabled && (isFocused || isSelected) ? '2px solid transparent' : ''
        }
      });
    },
    placeholder: function placeholder(css, _ref5) {
      var isDisabled = _ref5.isDisabled;
      return _objectSpread(_objectSpread({}, css), {}, {
        color: isDisabled ? "var(--ds-text-disabled, ".concat(_colors.N300, ")") : "var(--ds-text-subtlest, ".concat(_colors.N200, ")")
      });
    },
    singleValue: function singleValue(css, _ref6) {
      var isDisabled = _ref6.isDisabled;
      return _objectSpread(_objectSpread({}, css), {}, {
        color: isDisabled ? "var(--ds-text-disabled, ".concat(_colors.N70, ")") : "var(--ds-text, ".concat(_colors.N800, ")"),
        lineHeight: "var(--ds-font-lineHeight-100, 16px)" // 16px
      });
    },

    menu: function menu(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        backgroundColor: "var(--ds-surface-overlay, white)",
        boxShadow: "var(--ds-shadow-overlay, 0 0 0 1px hsl(0deg 0% 0% / 10%), 0 4px 11px hsl(0deg 0% 0% / 10%))"
      });
    },
    menuList: function menuList(css) {
      return _objectSpread(_objectSpread({}, css), {}, {
        paddingTop: "var(--ds-space-100, 8px)",
        paddingBottom: "var(--ds-space-100, 8px)"
      });
    },
    multiValue: function multiValue(css, _ref7) {
      var isDisabled = _ref7.isDisabled,
        isFocused = _ref7.isFocused;
      var backgroundColor;
      var color;
      if (isDisabled) {
        // Use the basic neutral background so it is slightly separate from the
        // field's background
        backgroundColor = "var(--ds-background-neutral, ".concat(_colors.N40, ")");
        color = "var(--ds-text-disabled, ".concat(_colors.N70, ")");
      } else if (isFocused) {
        backgroundColor = "var(--ds-background-selected, ".concat(_colors.N40, ")");
        color = "var(--ds-text-selected, hsl(0, 0%, 20%))";
      } else {
        backgroundColor = "var(--ds-background-neutral, ".concat(_colors.N40, ")");
        color = "var(--ds-text, hsl(0, 0%, 20%))";
      }
      return _objectSpread(_objectSpread({}, css), {}, {
        borderRadius: "var(--ds-border-radius-050, 2px)",
        backgroundColor: backgroundColor,
        boxShadow: isFocused ? "0 0 0 2px ".concat("var(--ds-surface, transparent)", ", 0 0 0 4px ", "var(--ds-border-focused, transparent)") : 'none',
        maxWidth: '100%',
        '@media screen and (-ms-high-contrast: active)': {
          border: isFocused ? '1px solid transparent' : 'none'
        },
        color: color
      });
    },
    multiValueLabel: function multiValueLabel(css, _ref8) {
      var isDisabled = _ref8.isDisabled;
      return _objectSpread(_objectSpread({}, css), {}, {
        padding: "var(--ds-space-025, 2px)",
        color: isDisabled ? "var(--ds-text-disabled, ".concat(_colors.N70, ")") : 'inherit',
        paddingRight: "var(--ds-space-025, 2px)"
      });
    },
    multiValueRemove: function multiValueRemove(css, _ref9) {
      var isFocused = _ref9.isFocused;
      return _objectSpread(_objectSpread({}, css), {}, {
        backgroundColor: isFocused ? "var(--ds-UNSAFE-transparent, ".concat(_colors.R75, ")") : undefined,
        fill: isFocused ? "var(--ds-text-selected, #000)" : "var(--ds-text, #000)",
        paddingLeft: "var(--ds-space-025, 2px)",
        paddingRight: "var(--ds-space-025, 2px)",
        borderRadius: '0px 2px 2px 0px',
        // DSP-6470 we should style like Tag once we have the :has selector
        ':hover': {
          backgroundColor: "var(--ds-background-danger-hovered, ".concat(_colors.R75, ")"),
          fill: "var(--ds-text-danger, #000)"
        },
        ':active': {
          backgroundColor: "var(--ds-background-danger-pressed, ".concat(_colors.R75, ")"),
          fill: "var(--ds-text-danger, #000)"
        }
      });
    }
  };
}