import _extends from "@babel/runtime/helpers/extends";
import React, { useMemo } from 'react';
import Select from './Select';
import { CheckboxOption } from './components/input-options';
const CheckboxSelect = /*#__PURE__*/React.memo(({
  components,
  ...props
}) => {
  const mergedComponents = useMemo(() => ({
    ...components,
    Option: CheckboxOption
  }), [components]);
  return /*#__PURE__*/React.createElement(Select, _extends({
    closeMenuOnSelect: false,
    hideSelectedOptions: false,
    isMulti: true
  }, props, {
    components: mergedComponents
  }));
});
export default CheckboxSelect;