import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { jsx, css } from '@emotion/react';
import { groupedCountries } from './data/countries';
import Select from './Select';
// custom option renderer
const labelStyles = css({
  alignItems: 'center',
  display: 'flex',
  lineHeight: 1.2
});
const flagStyles = css({
  fontSize: '18px',
  marginRight: "var(--ds-space-100, 8px)"
});
const Opt = ({
  children,
  icon
}) => jsx("div", {
  css: labelStyles
}, jsx("span", {
  css: flagStyles
}, icon), children);

// return the country name; used for searching
const getOptionLabel = ({
  abbr,
  code,
  name
}) => `${name} (${abbr.toUpperCase()}) +${code}`;

// set the country's abbreviation for the option value, (also searchable)
const getOptionValue = opt => opt.abbr;

// the text node of the control
const controlLabel = opt => jsx(Opt, {
  icon: opt.icon
}, opt.abbr.toUpperCase());
// the text node for an option
const optionLabel = ({
  abbr,
  code,
  icon,
  name
}) => jsx(Opt, {
  icon: icon
}, getOptionLabel({
  abbr,
  code,
  name
}));

// switch formatters based on render context (menu | value)
const formatOptionLabel = (opt, {
  context
}) => context === 'value' ? controlLabel(opt) : optionLabel(opt);

// put it all together
const CountrySelect = props => jsx(Select, _extends({
  isClearable: false,
  formatOptionLabel: formatOptionLabel,
  getOptionLabel: getOptionLabel,
  getOptionValue: getOptionValue,
  isMulti: false,
  options: groupedCountries
}, props));
export default CountrySelect;