import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { components } from 'react-select';
import { jsx } from '@emotion/react';
import VisuallyHidden from '@atlaskit/visually-hidden';
import SearchIcon from '@atlaskit/icon/glyph/editor/search';
import { layers } from '@atlaskit/theme/constants';
import { N40A } from '@atlaskit/theme/colors';

// ==============================
// Styled Components
// ==============================
export const MenuDialog = ({
  maxWidth,
  minWidth,
  children,
  id,
  style
}) => jsx("div", {
  css: {
    backgroundColor: "var(--ds-surface-overlay, white)",
    borderRadius: 4,
    boxShadow: `var(--ds-shadow-overlay, ${`0 0 0 1px ${N40A}, 0 4px 11px ${N40A}`})`,
    maxWidth,
    minWidth,
    zIndex: layers.modal()
  },
  style: style,
  id: id
}, children);

// ==============================
// Custom Components
// ==============================

const DropdownIndicator = () => jsx("div", {
  css: {
    marginRight: "var(--ds-space-025, 2px)",
    textAlign: 'center',
    width: 32
  }
}, jsx(SearchIcon, {
  label: "open"
}));
const Control = ({
  innerRef,
  innerProps,
  ...props
}) => jsx("div", {
  ref: innerRef,
  css: {
    padding: `${"var(--ds-space-100, 8px)"} ${"var(--ds-space-100, 8px)"} ${"var(--ds-space-050, 4px)"}`
  }
}, jsx(components.Control, _extends({}, props, {
  innerProps: innerProps
})));
export const DummyControl = props => jsx(VisuallyHidden, null, jsx(components.Control, props));

// NOTE `props` intentionally omitted from `Fragment`
// eslint-disable-next-line
const Menu = ({
  children,
  innerProps,
  ...props
}) => jsx("div", innerProps, children);
export const defaultComponents = {
  Control,
  DropdownIndicator,
  Menu
};