/** @jsx jsx */
import { jsx, css } from '@emotion/react';
import SelectClearIcon from '@atlaskit/icon/glyph/select-clear';
import { components } from 'react-select';
export { ClearIndicator, DropdownIndicator, LoadingIndicator } from './indicators';
const disabledProps = css`
  display: none;
`;
const enabledProps = css`
  display: inherit;
`;
export const MultiValueRemove = props => {
  const {
    isDisabled
  } = props.selectProps;
  return jsx(components.MultiValueRemove, props, jsx("div", {
    css: isDisabled ? disabledProps : enabledProps,
    "data-testid": isDisabled ? 'hide-clear-icon' : 'show-clear-icon'
  }, jsx(SelectClearIcon, {
    label: "Clear",
    size: "small",
    primaryColor: "transparent",
    secondaryColor: "inherit"
  })));
};
export const IndicatorSeparator = null;