import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { jsx, css } from '@emotion/react';
import { components } from 'react-select';
import Spinner from '@atlaskit/spinner';
import SelectClearIcon from '@atlaskit/icon/glyph/select-clear';
import DownIcon from '@atlaskit/icon/glyph/chevron-down';
const iconContainerStyles = css({
  all: 'unset',
  outline: 'revert',
  display: 'flex',
  alignItems: 'center'
});
export const ClearIndicator = props => jsx(components.ClearIndicator, _extends({}, props, {
  innerProps: {
    ...props.innerProps,
    'aria-hidden': 'false'
  }
}), jsx("button", {
  css: iconContainerStyles,
  type: "button",
  tabIndex: -1
}, jsx(SelectClearIcon, {
  size: "small",
  label: "clear"
})));
export const DropdownIndicator = props => jsx(components.DropdownIndicator, props, jsx(DownIcon, {
  label: "open"
}));
export const LoadingIndicator = props => {
  const loadingCSS = css(props.getStyles('loadingIndicator', props));
  return jsx("div", _extends({
    css: loadingCSS
  }, props.innerProps), jsx(Spinner, {
    size: "small"
  }));
};