import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/** @jsx jsx */
import { jsx } from '@emotion/react';
import { Component } from 'react';
import RadioIcon from '@atlaskit/icon/glyph/radio';
import CheckboxIcon from '@atlaskit/icon/glyph/checkbox';
import { themed } from '@atlaskit/theme/components';
import { B100, B200, B300, B400, B75, DN200, DN10, DN30, N20A, N0, N100, N20, N30, N70 } from '@atlaskit/theme/colors';
const getPrimitiveStyles = props => {
  const {
    cx,
    className,
    getStyles,
    isDisabled,
    isFocused,
    isSelected
  } = props;
  const styles = {
    alignItems: 'center',
    backgroundColor: isFocused ? `var(--ds-background-neutral-subtle-hovered, ${N20})` : 'transparent',
    color: isDisabled ? "var(--ds-text-disabled, inherit)" : 'inherit',
    display: 'flex ',
    paddingBottom: "var(--ds-space-050, 4px)",
    paddingLeft: "var(--ds-space-200, 16px)",
    paddingTop: "var(--ds-space-050, 4px)",
    boxShadow: isFocused ? `inset 2px 0px 0px ${`var(--ds-border-focused, ${B400})`};` : '',
    ':active': {
      backgroundColor: `var(--ds-background-neutral-subtle-pressed, ${N30})`
    },
    '@media screen and (-ms-high-contrast: active)': {
      borderLeft: isFocused ? '2px solid transparent' : ''
    }
  };
  const augmentedStyles = {
    ...getStyles('option', props),
    ...styles
  };
  const bemClasses = {
    option: true,
    'option--is-disabled': isDisabled,
    'option--is-focused': isFocused,
    'option--is-selected': isSelected
  };

  // maintain react-select API
  return [augmentedStyles, cx(bemClasses, className)];
};

// maintains function shape
const backgroundColor = themed({
  light: `var(--ds-background-neutral, ${N0})`,
  dark: `var(--ds-background-neutral, ${DN10})`
});
const transparent = themed({
  light: 'transparent',
  dark: 'transparent'
});

// state of the parent option

// the primary color represents the outer or background element
const getPrimaryColor = ({
  isActive,
  isDisabled,
  isFocused,
  isSelected,
  ...rest
}) => {
  let color = backgroundColor;
  if (isDisabled && isSelected) {
    color = themed({
      light: `var(--ds-background-disabled, ${B75})`,
      dark: `var(--ds-background-disabled, ${DN200})`
    });
  } else if (isDisabled) {
    color = themed({
      light: `var(--ds-background-disabled, ${N20A})`,
      dark: `var(--ds-background-disabled, ${DN10})`
    });
  } else if (isSelected && isActive) {
    color = themed({
      light: `var(--ds-background-selected-bold-pressed, ${B75})`,
      dark: `var(--ds-background-selected-bold-pressed, ${B200})`
    });
  } else if (isActive) {
    color = themed({
      light: `var(--ds-background-selected-pressed, ${B75})`,
      dark: `var(--ds-background-selected-pressed, ${B200})`
    });
  } else if (isFocused && isSelected) {
    color = themed({
      light: `var(--ds-background-selected-bold-hovered, ${B300})`,
      dark: `var(--ds-background-selected-bold-hovered, ${B75})`
    });
  } else if (isFocused) {
    color = themed({
      light: `var(--ds-surface, ${N0})`,
      dark: `var(--ds-surface, ${DN30})`
    });
  } else if (isSelected) {
    color = themed({
      light: `var(--ds-background-selected-bold, ${B400})`,
      dark: `var(--ds-background-selected-bold, ${B100})`
    });
  }
  return color(rest);
};

// the secondary color represents the radio dot or checkmark
const getSecondaryColor = ({
  isActive,
  isDisabled,
  isSelected,
  ...rest
}) => {
  let color = themed({
    light: `var(--ds-surface, ${N0})`,
    dark: `var(--ds-surface, ${DN10})`
  });
  if (isDisabled && isSelected) {
    color = themed({
      light: `var(--ds-text-disabled, ${N70})`,
      dark: `var(--ds-text-disabled, ${DN10})`
    });
  } else if (isActive && isSelected && !isDisabled) {
    color = themed({
      light: `var(--ds-surface, ${B400})`,
      dark: `var(--ds-surface, ${DN10})`
    });
  } else if (!isSelected) {
    color = transparent;
  }
  return color(rest);
};

// the border color surrounds the checkbox/radio
const getBorderColor = ({
  isActive,
  isDisabled,
  isFocused,
  isSelected,
  ...rest
}) => {
  if (isDisabled && isSelected) {
    return `var(--ds-background-disabled, ${B400})`;
  } else if (isDisabled) {
    return `var(--ds-background-disabled, ${N100})`;
  } else if (isSelected && isActive) {
    return `var(--ds-background-selected-bold-pressed, ${B400})`;
  } else if (isActive) {
    return `var(--ds-background-selected-bold, ${B400})`;
  } else if (isFocused && isSelected) {
    return `var(--ds-background-selected-bold-hovered, ${B400})`;
  } else if (isFocused) {
    return `var(--ds-border-input, ${N100})`;
  } else if (isSelected) {
    return `var(--ds-background-selected-bold, ${B400})`;
  }
  return `var(--ds-border-input, ${N100})`;
};
class ControlOption extends Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      isActive: false
    });
    _defineProperty(this, "onMouseDown", () => this.setState({
      isActive: true
    }));
    _defineProperty(this, "onMouseUp", () => this.setState({
      isActive: false
    }));
    _defineProperty(this, "onMouseLeave", () => this.setState({
      isActive: false
    }));
  }
  render() {
    const {
      getStyles,
      Icon,
      children,
      innerProps,
      innerRef,
      ...rest
    } = this.props;

    // prop assignment
    const props = {
      ...innerProps,
      onMouseDown: this.onMouseDown,
      onMouseUp: this.onMouseUp,
      onMouseLeave: this.onMouseLeave
    };
    const [styles, classes] = getPrimitiveStyles({
      getStyles,
      ...rest
    });
    return (
      /**
       * TODO Fix this type error
       * @see https://product-fabric.atlassian.net/browse/DSP-6063
       */
      // @ts-ignore
      jsx("div", _extends({
        css: styles,
        className: classes,
        ref: innerRef
      }, props), jsx("div", {
        css: {
          alignItems: 'center',
          display: 'flex ',
          flexShrink: 0,
          paddingRight: "var(--ds-space-050, 4px)",
          // Here we are adding a border to the Checkbox and Radio SVG icons
          // This is an a11y fix for Select only for now but it may be rolled
          // into the `@atlaskit/icon` package's Checkbox and Radio SVGs later
          '& svg rect, & svg circle:first-of-type': {
            stroke: getBorderColor({
              ...this.props,
              ...this.state
            }),
            strokeWidth: '2px',
            strokeLinejoin: 'round'
          }
        }
      }, !!Icon ? jsx(Icon, {
        label: "",
        primaryColor: getPrimaryColor({
          ...this.props,
          ...this.state
        }),
        secondaryColor: getSecondaryColor({
          ...this.props,
          ...this.state
        })
      }) : null), jsx("div", {
        css: {
          textOverflow: 'ellipsis',
          overflowX: 'hidden',
          flexGrow: 1,
          whiteSpace: 'nowrap'
        }
      }, children))
    );
  }
}
export const CheckboxOption = props => jsx(ControlOption, _extends({
  Icon: CheckboxIcon
}, props));
export const RadioOption = props => jsx(ControlOption, _extends({
  Icon: RadioIcon
}, props));