import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import { mergeStyles } from 'react-select';
import memoizeOne from 'memoize-one';
import isEqual from 'react-fast-compare';
import * as defaultComponents from './components';
import baseStyles from './styles';
import { onFocus, isOptionsGrouped } from './utils/grouped-options-announcement';
export default function createSelect(WrappedComponent) {
  var _class;
  return _class = class AtlaskitSelect extends Component {
    constructor(props) {
      super(props);
      _defineProperty(this, "components", {});
      _defineProperty(this, "select", null);
      _defineProperty(this, "cacheComponents", components => {
        this.components = {
          ...defaultComponents,
          ...components
        };
      });
      _defineProperty(this, "onSelectRef", ref => {
        this.select = ref;
      });
      this.cacheComponents = memoizeOne(this.cacheComponents, isEqual).bind(this);
      this.cacheComponents(props.components || {});
    }
    UNSAFE_componentWillReceiveProps(nextProps) {
      this.cacheComponents(nextProps.components);
    }
    focus() {
      if (this.select) {
        this.select.focus();
      }
    }
    blur() {
      if (this.select) {
        this.select.blur();
      }
    }
    render() {
      const {
        styles,
        validationState,
        isInvalid,
        spacing,
        isMulti,
        appearance,
        ariaLiveMessages,
        ...props
      } = this.props;
      const isCompact = spacing === 'compact';

      // props must be spread first to stop `components` being overridden
      return /*#__PURE__*/React.createElement(WrappedComponent, _extends({
        ref: this.onSelectRef,
        isMulti: isMulti,
        "aria-live": "assertive",
        ariaLiveMessages: isOptionsGrouped(this.props.options) ? {
          onFocus,
          ...ariaLiveMessages
        } : {
          ...ariaLiveMessages
        }
      }, props, {
        components: this.components,
        styles: mergeStyles(baseStyles(
        // This will cover both props for invalid state while giving priority to isInvalid. When cleaning up validationState, we can just keep the inner condition.
        typeof isInvalid !== 'undefined' ? isInvalid ? 'error' : 'default' : validationState, isCompact, this.props.appearance || 'default'), styles)
      }));
    }
  }, _defineProperty(_class, "defaultProps", {
    validationState: 'default',
    // TODO: uncomment the next line when cleaning up validationState prop so it has a default value
    // isInvalid: false,
    spacing: 'default',
    onClickPreventDefault: true,
    tabSelectsValue: false,
    components: {},
    styles: {}
  }), _class;
}