// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize, fontFamily } from '@atlaskit/theme/constants';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { B100, B400, B50, G400, N0, N100, N20, N200, N30, N300, N40, N500, N70, N800, R400, R75 } from '@atlaskit/theme/colors';
const BORDER_WIDTH = 2;
const ICON_PADDING = 2;
const paddingExcludingBorder = gridSize() - BORDER_WIDTH;
export default function baseStyles(validationState, isCompact = false, appearance) {
  return {
    container: (css, {
      isDisabled
    }) => ({
      ...css,
      fontFamily: `var(--ds-font-family-sans, ${fontFamily()})`,
      // react-select disables pointer events when isDisabled is true.
      // We override this and make the inner container turn it off instead.
      pointerEvents: 'all',
      cursor: isDisabled ? 'not-allowed' : css.cursor
    }),
    input: css => ({
      ...css,
      color: "var(--ds-text, hsl(0, 0%, 20%))"
    }),
    control: (css, {
      isFocused,
      isDisabled
    }) => {
      let borderColor = isFocused ? `var(--ds-border-focused, ${B100})` : `var(--ds-border-input, ${getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? N100 : N20})`;
      let backgroundColor = isFocused ? `var(--ds-background-input-pressed, ${N0})` : `var(--ds-background-input, ${N20})`;
      let backgroundColorHover = isFocused ? `var(--ds-background-input-pressed, ${N0})` : `var(--ds-background-input-hovered, ${N30})`;
      if (isDisabled) {
        backgroundColor = `var(--ds-background-disabled, ${N20})`;
        borderColor = `var(--ds-background-disabled, ${N20})`;
      }
      if (validationState === 'error') {
        borderColor = `var(--ds-border-danger, ${R400})`;
      }
      if (validationState === 'success') {
        borderColor = `var(--ds-border-success, ${G400})`;
      }
      let borderColorHover = isFocused ? `var(--ds-border-focused, ${B100})` : `var(--ds-border-input, ${getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? N100 : N30})`;
      if (validationState === 'error') {
        borderColorHover = `var(--ds-border-danger, ${R400})`;
      }
      if (validationState === 'success') {
        borderColorHover = `var(--ds-border-success, ${G400})`;
      }
      const transitionDuration = '200ms';
      if (appearance === 'subtle') {
        borderColor = isFocused ? `var(--ds-border-focused, ${B100})` : 'transparent';
        backgroundColor = isFocused ? `var(--ds-surface, ${N0})` : 'transparent';
        backgroundColorHover = isFocused ? `var(--ds-background-input-pressed, ${N0})` : `var(--ds-background-input-hovered, ${N30})`;
      }
      if (appearance === 'none') {
        borderColor = 'transparent';
        backgroundColor = 'transparent';
        backgroundColorHover = 'transparent';
        borderColorHover = 'transparent';
      }
      return {
        ...css,
        // Turn pointer events off when disabled - this makes it so hover etc don't work.
        pointerEvents: isDisabled ? 'none' : undefined,
        backgroundColor,
        borderColor,
        borderStyle: 'solid',
        borderRadius: "var(--ds-border-radius-100, 3px)",
        borderWidth: getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? "var(--ds-border-width, 1px)" : "var(--ds-border-width-outline, 2px)",
        boxShadow: 'none',
        ...(getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') && {
          '&:focus-within': {
            boxShadow: `inset 0 0 0 ${"var(--ds-border-width, 1px)"} ${borderColor}`
          }
        }),
        minHeight: isCompact ? gridSize() * 4 : gridSize() * 5,
        padding: 0,
        transition: `background-color ${transitionDuration} ease-in-out,
        border-color ${transitionDuration} ease-in-out`,
        '::-webkit-scrollbar': {
          height: gridSize(),
          width: gridSize()
        },
        '::-webkit-scrollbar-corner': {
          display: 'none'
        },
        ':hover': {
          '::-webkit-scrollbar-thumb': {
            // scrollbars occur only if the user passes in a custom component with overflow: scroll
            // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
            backgroundColor: 'rgba(0,0,0,0.2)'
          },
          cursor: 'pointer',
          backgroundColor: backgroundColorHover,
          borderColor: borderColorHover
        },
        '::-webkit-scrollbar-thumb:hover': {
          // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
          backgroundColor: 'rgba(0,0,0,0.4)'
        }
      };
    },
    valueContainer: css => ({
      ...css,
      paddingLeft: paddingExcludingBorder,
      paddingRight: paddingExcludingBorder,
      paddingBottom: isCompact ? 0 : 2,
      paddingTop: isCompact ? 0 : 2
    }),
    clearIndicator: css => ({
      ...css,
      color: `var(--ds-text-subtlest, ${N70})`,
      paddingLeft: ICON_PADDING,
      paddingRight: ICON_PADDING,
      paddingBottom: isCompact ? 0 : 6,
      paddingTop: isCompact ? 0 : 6,
      ':hover': {
        color: `var(--ds-text-subtle, ${N500})`
      }
    }),
    loadingIndicator: css => ({
      ...css,
      paddingBottom: isCompact ? 0 : 6,
      paddingTop: isCompact ? 0 : 6
    }),
    dropdownIndicator: (css, {
      isDisabled
    }) => {
      let color = `var(--ds-text-subtle, ${N500})`;
      if (isDisabled) {
        color = `var(--ds-text-disabled, ${N70})`;
      }
      return {
        ...css,
        color,
        paddingLeft: ICON_PADDING,
        paddingRight: ICON_PADDING,
        paddingBottom: isCompact ? 0 : 6,
        paddingTop: isCompact ? 0 : 6,
        ':hover': {
          color: `var(--ds-text-subtle, ${N200})`
        }
      };
    },
    indicatorsContainer: css => ({
      ...css,
      paddingRight: paddingExcludingBorder - ICON_PADDING
    }),
    option: (css, {
      isFocused,
      isSelected,
      isDisabled
    }) => {
      let color = `var(--ds-text, ${N800})`;
      if (isDisabled) {
        color = `var(--ds-text-disabled, ${N70})`;
      } else if (isSelected) {
        color = `var(--ds-text-selected, ${B400})`;
      }
      let boxShadow;
      let backgroundColor;
      if (isDisabled) {
        backgroundColor = undefined;
      } else if (isSelected && isFocused) {
        backgroundColor = `var(--ds-background-selected-hovered, ${B50})`;
      } else if (isSelected) {
        backgroundColor = `var(--ds-background-selected, ${B50})`;
      } else if (isFocused) {
        backgroundColor = `var(--ds-background-neutral-subtle-hovered, ${N20})`;
      }
      if (!isDisabled && (isFocused || isSelected)) {
        boxShadow = `inset 2px 0px 0px ${`var(--ds-border-selected, ${B400})`}`;
      }
      const cursor = isDisabled ? 'not-allowed' : css.cursor;
      return {
        ...css,
        padding: '6px 12px',
        backgroundColor,
        color,
        cursor,
        boxShadow,
        ':active': {
          backgroundColor: !isDisabled ? isSelected ? `var(--ds-background-selected-pressed, ${N20})` : `var(--ds-background-neutral-subtle-pressed, ${N30})` : undefined
        },
        '@media screen and (-ms-high-contrast: active)': {
          borderLeft: !isDisabled && (isFocused || isSelected) ? '2px solid transparent' : ''
        }
      };
    },
    placeholder: (css, {
      isDisabled
    }) => ({
      ...css,
      color: isDisabled ? `var(--ds-text-disabled, ${N300})` : `var(--ds-text-subtlest, ${N200})`
    }),
    singleValue: (css, {
      isDisabled
    }) => ({
      ...css,
      color: isDisabled ? `var(--ds-text-disabled, ${N70})` : `var(--ds-text, ${N800})`,
      lineHeight: "var(--ds-font-lineHeight-100, 16px)" // 16px
    }),

    menu: css => ({
      ...css,
      backgroundColor: "var(--ds-surface-overlay, white)",
      boxShadow: "var(--ds-shadow-overlay, 0 0 0 1px hsl(0deg 0% 0% / 10%), 0 4px 11px hsl(0deg 0% 0% / 10%))"
    }),
    menuList: css => ({
      ...css,
      paddingTop: "var(--ds-space-100, 8px)",
      paddingBottom: "var(--ds-space-100, 8px)"
    }),
    multiValue: (css, {
      isDisabled,
      isFocused
    }) => {
      let backgroundColor;
      let color;
      if (isDisabled) {
        // Use the basic neutral background so it is slightly separate from the
        // field's background
        backgroundColor = `var(--ds-background-neutral, ${N40})`;
        color = `var(--ds-text-disabled, ${N70})`;
      } else if (isFocused) {
        backgroundColor = `var(--ds-background-selected, ${N40})`;
        color = "var(--ds-text-selected, hsl(0, 0%, 20%))";
      } else {
        backgroundColor = `var(--ds-background-neutral, ${N40})`;
        color = "var(--ds-text, hsl(0, 0%, 20%))";
      }
      return {
        ...css,
        borderRadius: "var(--ds-border-radius-050, 2px)",
        backgroundColor,
        boxShadow: isFocused ? `0 0 0 2px ${"var(--ds-surface, transparent)"}, 0 0 0 4px ${"var(--ds-border-focused, transparent)"}` : 'none',
        maxWidth: '100%',
        '@media screen and (-ms-high-contrast: active)': {
          border: isFocused ? '1px solid transparent' : 'none'
        },
        color
      };
    },
    multiValueLabel: (css, {
      isDisabled
    }) => ({
      ...css,
      padding: "var(--ds-space-025, 2px)",
      color: isDisabled ? `var(--ds-text-disabled, ${N70})` : 'inherit',
      paddingRight: "var(--ds-space-025, 2px)"
    }),
    multiValueRemove: (css, {
      isFocused
    }) => ({
      ...css,
      backgroundColor: isFocused ? `var(--ds-UNSAFE-transparent, ${R75})` : undefined,
      fill: isFocused ? "var(--ds-text-selected, #000)" : "var(--ds-text, #000)",
      paddingLeft: "var(--ds-space-025, 2px)",
      paddingRight: "var(--ds-space-025, 2px)",
      borderRadius: '0px 2px 2px 0px',
      // DSP-6470 we should style like Tag once we have the :has selector
      ':hover': {
        backgroundColor: `var(--ds-background-danger-hovered, ${R75})`,
        fill: "var(--ds-text-danger, #000)"
      },
      ':active': {
        backgroundColor: `var(--ds-background-danger-pressed, ${R75})`,
        fill: "var(--ds-text-danger, #000)"
      }
    })
  };
}