// Used for overwriting ariaLiveMessages builtin onFocus method.
// Returns custom built string while focusing each group option. This string is used for screen reader announcement.
export function onFocus(props) {
  var _groupData$options$fi;
  const {
    focused,
    options
  } = props;
  const isOptionFocused = option => {
    return option === focused;
  };
  const groupData = options === null || options === void 0 ? void 0 : options.find(option => {
    var _option$options;
    return (_option$options = option.options) === null || _option$options === void 0 ? void 0 : _option$options.some(isOptionFocused);
  });
  const groupOptionIndex = (_groupData$options$fi = groupData === null || groupData === void 0 ? void 0 : groupData.options.findIndex(isOptionFocused)) !== null && _groupData$options$fi !== void 0 ? _groupData$options$fi : 0;
  return `Option ${focused.label}, ${groupData === null || groupData === void 0 ? void 0 : groupData.label} group, item ${groupOptionIndex + 1} out of ${groupData === null || groupData === void 0 ? void 0 : groupData.options.length}. All in all `;
}

// Helper function which identifies if options are grouped.
export const isOptionsGrouped = arr => {
  return arr === null || arr === void 0 ? void 0 : arr.every(obj => obj.hasOwnProperty('options'));
};