import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { jsx, css } from '@emotion/react';
import { groupedCountries } from './data/countries';
import Select from './Select';
// custom option renderer
var labelStyles = css({
  alignItems: 'center',
  display: 'flex',
  lineHeight: 1.2
});
var flagStyles = css({
  fontSize: '18px',
  marginRight: "var(--ds-space-100, 8px)"
});
var Opt = function Opt(_ref) {
  var children = _ref.children,
    icon = _ref.icon;
  return jsx("div", {
    css: labelStyles
  }, jsx("span", {
    css: flagStyles
  }, icon), children);
};

// return the country name; used for searching
var getOptionLabel = function getOptionLabel(_ref2) {
  var abbr = _ref2.abbr,
    code = _ref2.code,
    name = _ref2.name;
  return "".concat(name, " (").concat(abbr.toUpperCase(), ") +").concat(code);
};

// set the country's abbreviation for the option value, (also searchable)
var getOptionValue = function getOptionValue(opt) {
  return opt.abbr;
};

// the text node of the control
var controlLabel = function controlLabel(opt) {
  return jsx(Opt, {
    icon: opt.icon
  }, opt.abbr.toUpperCase());
};
// the text node for an option
var optionLabel = function optionLabel(_ref3) {
  var abbr = _ref3.abbr,
    code = _ref3.code,
    icon = _ref3.icon,
    name = _ref3.name;
  return jsx(Opt, {
    icon: icon
  }, getOptionLabel({
    abbr: abbr,
    code: code,
    name: name
  }));
};

// switch formatters based on render context (menu | value)
var formatOptionLabel = function formatOptionLabel(opt, _ref4) {
  var context = _ref4.context;
  return context === 'value' ? controlLabel(opt) : optionLabel(opt);
};

// put it all together
var CountrySelect = function CountrySelect(props) {
  return jsx(Select, _extends({
    isClearable: false,
    formatOptionLabel: formatOptionLabel,
    getOptionLabel: getOptionLabel,
    getOptionValue: getOptionValue,
    isMulti: false,
    options: groupedCountries
  }, props));
};
export default CountrySelect;