import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["footer", "maxMenuWidth", "minMenuWidth", "target"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
import React, { PureComponent } from 'react';
import { createPortal } from 'react-dom';
import FocusLock from 'react-focus-lock';
import Select, { mergeStyles } from 'react-select';
import { uid } from 'react-uid';
import { Manager, Reference, Popper } from 'react-popper';
import NodeResolver from 'react-node-resolver';
import shallowEqualObjects from 'shallow-equal/objects';
import { N80 } from '@atlaskit/theme/colors';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { MenuDialog, DummyControl, defaultComponents } from './components';
import baseStyles from '../styles';
import { bind } from 'bind-event-listener';
import memoizeOne from 'memoize-one';
/** Are we rendering on the client or server? */
var canUseDOM = function canUseDOM() {
  return Boolean(typeof window !== 'undefined' && window.document && window.document.createElement);
};

// ==============================
// Types
// ==============================
// ==============================
// Class
// ==============================
var modifiers = [{
  name: 'offset',
  options: {
    offset: [0, 8]
  }
}, {
  name: 'preventOverflow',
  enabled: true,
  options: {
    padding: 5,
    boundary: 'clippingParents',
    altAxis: true,
    altBoundary: true
  }
}];
var defaultPopperProps = {
  modifiers: modifiers,
  placement: 'bottom-start'
};
var isEmpty = function isEmpty(obj) {
  return Object.keys(obj).length === 0;
};
var PopupSelect = /*#__PURE__*/function (_PureComponent) {
  _inherits(PopupSelect, _PureComponent);
  var _super = _createSuper(PopupSelect);
  function PopupSelect() {
    var _this$defaultOpenStat, _this$defaultOpenStat2;
    var _this;
    _classCallCheck(this, PopupSelect);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "menuRef", null);
    _defineProperty(_assertThisInitialized(_this), "selectRef", null);
    _defineProperty(_assertThisInitialized(_this), "targetRef", null);
    _defineProperty(_assertThisInitialized(_this), "unbindWindowClick", null);
    _defineProperty(_assertThisInitialized(_this), "unbindWindowKeydown", null);
    _defineProperty(_assertThisInitialized(_this), "defaultStyles", mergeStyles(baseStyles(_this.props.validationState || (_this.props.isInvalid ? 'error' : 'default'), _this.props.spacing === 'compact', 'default'), {
      groupHeading: function groupHeading(provided) {
        return _objectSpread(_objectSpread({}, provided), {}, {
          color: "var(--ds-text-subtlest, ".concat(N80, ")")
        });
      }
    }));
    _defineProperty(_assertThisInitialized(_this), "isOpenControlled", _this.props.isOpen !== undefined);
    _defineProperty(_assertThisInitialized(_this), "defaultOpenState", _this.isOpenControlled ? _this.props.isOpen : _this.props.defaultIsOpen);
    _defineProperty(_assertThisInitialized(_this), "state", getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? {
      isOpen: (_this$defaultOpenStat = _this.defaultOpenState) !== null && _this$defaultOpenStat !== void 0 ? _this$defaultOpenStat : false,
      mergedComponents: defaultComponents,
      mergedPopperProps: defaultPopperProps
    } : {
      focusLockEnabled: false,
      isOpen: (_this$defaultOpenStat2 = _this.defaultOpenState) !== null && _this$defaultOpenStat2 !== void 0 ? _this$defaultOpenStat2 : false,
      mergedComponents: defaultComponents,
      mergedPopperProps: defaultPopperProps
    });
    _defineProperty(_assertThisInitialized(_this), "popperWrapperId", "".concat(uid({
      options: _this.props.options
    }), "-popup-select"));
    // Event Handlers
    // ==============================
    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (event) {
      switch (event.key) {
        case 'Escape':
        case 'Esc':
          _this.close();
          break;
        default:
      }
      if (_this.props.onKeyDown) {
        /* @ts-ignore - updating type of event React.KeyboardEvent effects the unbindWindowsKeyDown listener. Check if this can be fixed once the component gets refactor to functional */
        _this.props.onKeyDown(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleClick", function (_ref) {
      var target = _ref.target;
      var isOpen = _this.state.isOpen;
      // appease flow
      if (!(target instanceof Element)) {
        return;
      }

      // NOTE: Why not use the <Blanket /> component to close?
      // We don't want to interupt the user's flow. Taking this approach allows
      // user to click "through" to other elements and close the popout.
      if (isOpen && _this.menuRef && !_this.menuRef.contains(target)) {
        _this.close();
      }

      // open on target click -- we can't trust consumers to spread the onClick
      // property to the target
      if (!isOpen && _this.targetRef && _this.targetRef.contains(target)) {
        _this.open();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleSelectChange", function (value, actionMeta) {
      var _this$props = _this.props,
        closeMenuOnSelect = _this$props.closeMenuOnSelect,
        onChange = _this$props.onChange;
      if (closeMenuOnSelect && actionMeta.action !== 'clear') {
        _this.close();
      }
      if (onChange) {
        onChange(value, actionMeta);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleFirstPopperUpdate", function () {
      // When the popup opens it's focused into. Since the popup is inside a portal, it's position is
      // initially set to 0,0 - this causes the window scroll position to jump to the top. To prevent
      // this we defer enabling the focus-lock until after Popper has positioned the popup the first time.
      _this.setState({
        focusLockEnabled: true
      });
    });
    // Internal Lifecycle
    // ==============================
    /**
     * Opens the popup
     *
     * @param options.controlOverride  - Force the popup to open when it's open state is being controlled
     */
    _defineProperty(_assertThisInitialized(_this), "open", function (options) {
      var onOpen = _this.props.onOpen;
      if (!(options !== null && options !== void 0 && options.controlOverride) && _this.isOpenControlled) {
        // Prevent popup opening if it's open state is already being controlled
        return;
      }
      if (onOpen) {
        onOpen();
      }
      _this.setState({
        isOpen: true
      });
      if (_this.selectRef) {
        _this.selectRef.openMenu('first');
      }
      if (typeof window === 'undefined') {
        return;
      }
      _this.unbindWindowKeydown = bind(window, {
        type: 'keydown',
        listener: _this.handleKeyDown,
        options: {
          capture: true
        }
      });
    });
    /**
     * Closes the popup
     *
     * @param options.controlOverride  - Force the popup to close when it's open state is being controlled
     */
    _defineProperty(_assertThisInitialized(_this), "close", function (options) {
      var _this$unbindWindowKey, _this2;
      var onClose = _this.props.onClose;
      if (!(options !== null && options !== void 0 && options.controlOverride) && _this.isOpenControlled) {
        // Prevent popup closing if it's open state is already being controlled
        return;
      }
      if (onClose) {
        onClose();
      }
      _this.setState({
        isOpen: false
      });
      if (getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m')) {
        // Do nothing… (the pff eslint just doesn't like `!getBooleanFF(…)`)
      } else {
        _this.setState({
          focusLockEnabled: false
        });
      }
      if (_this.targetRef != null) {
        _this.targetRef.focus();
      }
      if (typeof window === 'undefined') {
        return;
      }
      (_this$unbindWindowKey = (_this2 = _this).unbindWindowKeydown) === null || _this$unbindWindowKey === void 0 ? void 0 : _this$unbindWindowKey.call(_this2);
      _this.unbindWindowKeydown = null;
    });
    // Refs
    // ==============================
    _defineProperty(_assertThisInitialized(_this), "resolveTargetRef", function (popperRef) {
      return function (ref) {
        // avoid thrashing fn calls
        if (!_this.targetRef && popperRef && ref) {
          _this.targetRef = ref;
          if (typeof popperRef === 'function') {
            popperRef(ref);
          } else {
            popperRef.current = ref;
          }
        }
      };
    });
    _defineProperty(_assertThisInitialized(_this), "resolveMenuRef", function (popperRef) {
      return function (ref) {
        _this.menuRef = ref;
        if (typeof popperRef === 'function') {
          popperRef(ref);
        } else {
          popperRef.current = ref;
        }
      };
    });
    _defineProperty(_assertThisInitialized(_this), "getSelectRef", function (ref) {
      _this.selectRef = ref;
    });
    // Utils
    // ==============================
    // Get a memoized merge of the default styles and the prop's in styles
    _defineProperty(_assertThisInitialized(_this), "getSelectStyles", memoizeOne(function (defaultStyles, propStyles) {
      return mergeStyles(defaultStyles, propStyles || {});
    }));
    // Get a memoized override of our `<Select components={…}>` overrides.
    _defineProperty(_assertThisInitialized(_this), "getSelectComponents", memoizeOne(function (mergedComponents, showSearchControl) {
      if (!showSearchControl) {
        // When we have no search control, we use a dummy override to hide it visually.
        return _objectSpread(_objectSpread({}, mergedComponents), {}, {
          Control: DummyControl
        });
      }
      return mergedComponents;
    }));
    // account for groups when counting options
    // this may need to be recursive, right now it just counts one level
    _defineProperty(_assertThisInitialized(_this), "getItemCount", function () {
      var options = _this.props.options;
      var count = 0;
      options.forEach(function (groupOrOption) {
        if (groupOrOption.options) {
          groupOrOption.options.forEach(function () {
            return count++;
          });
        } else {
          count++;
        }
      });
      return count;
    });
    _defineProperty(_assertThisInitialized(_this), "getMaxHeight", function () {
      var maxMenuHeight = _this.props.maxMenuHeight;
      if (!_this.selectRef) {
        return maxMenuHeight;
      }

      // subtract the control height to maintain consistency
      var showSearchControl = _this.showSearchControl();
      var controlRef = _this.selectRef.controlRef;
      var offsetHeight = showSearchControl && controlRef ? controlRef.offsetHeight : 0;
      var maxHeight = maxMenuHeight - offsetHeight;
      return maxHeight;
    });
    // if the threshold is exceeded, AND isSearchable is true, then display the search control
    _defineProperty(_assertThisInitialized(_this), "showSearchControl", function () {
      var _this$props2 = _this.props,
        searchThreshold = _this$props2.searchThreshold,
        isSearchable = _this$props2.isSearchable;
      return isSearchable && _this.getItemCount() > searchThreshold;
    });
    // Renderers
    // ==============================
    _defineProperty(_assertThisInitialized(_this), "renderSelect", function () {
      var _this$props3 = _this.props,
        footer = _this$props3.footer,
        maxMenuWidth = _this$props3.maxMenuWidth,
        minMenuWidth = _this$props3.minMenuWidth,
        target = _this$props3.target,
        props = _objectWithoutProperties(_this$props3, _excluded);
      // TODO: If `platform.design-system-team.popup-select-render-perf_i0s6m` is kept, `focusLockEnabled` should be fully removed as we're preferring `isReferenceHidden`
      var _this$state = _this.state,
        focusLockEnabled = _this$state.focusLockEnabled,
        isOpen = _this$state.isOpen,
        mergedComponents = _this$state.mergedComponents,
        mergedPopperProps = _this$state.mergedPopperProps;
      var showSearchControl = _this.showSearchControl();
      var portalDestination = canUseDOM() ? document.body : null;
      if (!portalDestination || !isOpen) {
        return null;
      }

      // Memoized merge of defaultStyles and props.styles
      var selectStyles = getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? _this.getSelectStyles(_this.defaultStyles, props.styles) : mergeStyles(_this.defaultStyles, props.styles || {});

      // Memoized variance of the default select components
      var selectComponents = getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? _this.getSelectComponents(mergedComponents, showSearchControl) : _objectSpread(_objectSpread({}, mergedComponents), {}, {
        Control: showSearchControl ? mergedComponents.Control : DummyControl
      });
      var popper = /*#__PURE__*/React.createElement(Popper, _extends({}, mergedPopperProps, getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? undefined : {
        onFirstUpdate: function onFirstUpdate(state) {
          var _mergedPopperProps$on;
          _this.handleFirstPopperUpdate();
          (_mergedPopperProps$on = mergedPopperProps.onFirstUpdate) === null || _mergedPopperProps$on === void 0 ? void 0 : _mergedPopperProps$on.call(mergedPopperProps, state);
        }
      }), function (_ref2) {
        var placement = _ref2.placement,
          ref = _ref2.ref,
          style = _ref2.style,
          isReferenceHidden = _ref2.isReferenceHidden;
        /**
         * The reference is not available yet, so the Popper and Portal is either being rendered at `0,0` (scrolled to the top)
         * or not at all.  There's no reason to render the Select or lock scrolling at the top of the page yet.
         */
        var readyToRenderSelect = getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? isReferenceHidden !== null : true;
        return /*#__PURE__*/React.createElement(NodeResolver, {
          innerRef: _this.resolveMenuRef(ref)
        }, /*#__PURE__*/React.createElement(MenuDialog, {
          style: style,
          "data-placement": placement,
          minWidth: minMenuWidth,
          maxWidth: maxMenuWidth,
          id: _this.popperWrapperId
        }, /*#__PURE__*/React.createElement(FocusLock
        /*
         * NOTE: We intentionally want the FocusLock to be disabled until the refs are populated in Popper.
         * Until then, the portal the Popper creates is at `0,0`, meaning the FocusLock forces the page to scroll to `0,0`.
         * We do not want the user to scroll to the top of the page when they open their PopupSelect, so we disable it.
         *
         *  WARNING: This causes additional renders, eg. ±5ms in our example, but unless
         * FocusLock has a better way to avoid scrolling, this is necessary.
         */, {
          disabled: getBooleanFF('platform.design-system-team.popup-select-render-perf_i0s6m') ? !readyToRenderSelect : !focusLockEnabled,
          returnFocus: true
        }, readyToRenderSelect && /*#__PURE__*/React.createElement(Select, _extends({
          backspaceRemovesValue: false,
          controlShouldRenderValue: false,
          isClearable: false,
          tabSelectsValue: false,
          menuIsOpen: true,
          ref: _this.getSelectRef
        }, props, {
          isSearchable: showSearchControl,
          styles: selectStyles,
          maxMenuHeight: _this.getMaxHeight(),
          components: selectComponents,
          onChange: _this.handleSelectChange
        })), footer)));
      });
      return mergedPopperProps.strategy === 'fixed' ? popper : /*#__PURE__*/createPortal(popper, portalDestination);
    });
    return _this;
  }
  _createClass(PopupSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (typeof window === 'undefined') {
        return;
      }
      this.unbindWindowClick = bind(window, {
        type: 'click',
        listener: this.handleClick,
        options: {
          capture: true
        }
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var _this$unbindWindowCli, _this$unbindWindowKey2;
      if (typeof window === 'undefined') {
        return;
      }
      (_this$unbindWindowCli = this.unbindWindowClick) === null || _this$unbindWindowCli === void 0 ? void 0 : _this$unbindWindowCli.call(this);
      this.unbindWindowClick = null;
      (_this$unbindWindowKey2 = this.unbindWindowKeydown) === null || _this$unbindWindowKey2 === void 0 ? void 0 : _this$unbindWindowKey2.call(this);
      this.unbindWindowKeydown = null;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var isOpen = this.props.isOpen;
      if (prevProps.isOpen !== isOpen) {
        if (isOpen === true) {
          this.open({
            controlOverride: true
          });
        } else if (isOpen === false) {
          this.close({
            controlOverride: true
          });
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var target = this.props.target;
      var isOpen = this.state.isOpen;
      return /*#__PURE__*/React.createElement(Manager, null, /*#__PURE__*/React.createElement(Reference, null, function (_ref3) {
        var ref = _ref3.ref;
        return target && target({
          isOpen: isOpen,
          ref: _this3.resolveTargetRef(ref),
          'aria-haspopup': 'true',
          'aria-expanded': isOpen,
          'aria-controls': isOpen ? _this3.popperWrapperId : undefined
        });
      }), this.renderSelect());
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      var newState = {};

      // Merge consumer and default popper props
      var mergedPopperProps = _objectSpread(_objectSpread({}, defaultPopperProps), props.popperProps);
      if (!shallowEqualObjects(mergedPopperProps, state.mergedPopperProps)) {
        newState.mergedPopperProps = mergedPopperProps;
      }

      // Merge consumer and default components
      var mergedComponents = _objectSpread(_objectSpread({}, defaultComponents), props.components);
      if (!shallowEqualObjects(mergedComponents, state.mergedComponents)) {
        newState.mergedComponents = mergedComponents;
      }
      if (!isEmpty(newState)) {
        return newState;
      }
      return null;
    }
  }]);
  return PopupSelect;
}(PureComponent);
_defineProperty(PopupSelect, "defaultProps", {
  closeMenuOnSelect: true,
  components: {},
  maxMenuHeight: 300,
  maxMenuWidth: 440,
  minMenuWidth: 220,
  popperProps: {},
  isSearchable: true,
  searchThreshold: 5,
  styles: {},
  options: []
});
export { PopupSelect as default };