import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["innerRef", "innerProps"],
  _excluded2 = ["children", "innerProps"];
/** @jsx jsx */

import { components } from 'react-select';
import { jsx } from '@emotion/react';
import VisuallyHidden from '@atlaskit/visually-hidden';
import SearchIcon from '@atlaskit/icon/glyph/editor/search';
import { layers } from '@atlaskit/theme/constants';
import { N40A } from '@atlaskit/theme/colors';

// ==============================
// Styled Components
// ==============================
export var MenuDialog = function MenuDialog(_ref) {
  var maxWidth = _ref.maxWidth,
    minWidth = _ref.minWidth,
    children = _ref.children,
    id = _ref.id,
    style = _ref.style;
  return jsx("div", {
    css: {
      backgroundColor: "var(--ds-surface-overlay, white)",
      borderRadius: 4,
      boxShadow: "var(--ds-shadow-overlay, ".concat("0 0 0 1px ".concat(N40A, ", 0 4px 11px ").concat(N40A), ")"),
      maxWidth: maxWidth,
      minWidth: minWidth,
      zIndex: layers.modal()
    },
    style: style,
    id: id
  }, children);
};

// ==============================
// Custom Components
// ==============================

var DropdownIndicator = function DropdownIndicator() {
  return jsx("div", {
    css: {
      marginRight: "var(--ds-space-025, 2px)",
      textAlign: 'center',
      width: 32
    }
  }, jsx(SearchIcon, {
    label: "open"
  }));
};
var Control = function Control(_ref2) {
  var innerRef = _ref2.innerRef,
    innerProps = _ref2.innerProps,
    props = _objectWithoutProperties(_ref2, _excluded);
  return jsx("div", {
    ref: innerRef,
    css: {
      padding: "var(--ds-space-100, 8px)".concat(" ", "var(--ds-space-100, 8px)", " ", "var(--ds-space-050, 4px)")
    }
  }, jsx(components.Control, _extends({}, props, {
    innerProps: innerProps
  })));
};
export var DummyControl = function DummyControl(props) {
  return jsx(VisuallyHidden, null, jsx(components.Control, props));
};

// NOTE `props` intentionally omitted from `Fragment`
// eslint-disable-next-line
var Menu = function Menu(_ref3) {
  var children = _ref3.children,
    innerProps = _ref3.innerProps,
    props = _objectWithoutProperties(_ref3, _excluded2);
  return jsx("div", innerProps, children);
};
export var defaultComponents = {
  Control: Control,
  DropdownIndicator: DropdownIndicator,
  Menu: Menu
};