import Select from 'react-select';
import { withAnalyticsEvents, withAnalyticsContext, createAndFireEvent } from '@atlaskit/analytics-next';
import createSelect from './createSelect';
var packageName = "@atlaskit/select";
var packageVersion = "16.5.7";
export var SelectWithoutAnalytics = createSelect(Select);
var createAndFireEventOnAtlaskit = createAndFireEvent('atlaskit');
export default withAnalyticsContext({
  componentName: 'select',
  packageName: packageName,
  packageVersion: packageVersion
})(withAnalyticsEvents({
  onChange: createAndFireEventOnAtlaskit({
    action: 'changed',
    actionSubject: 'option',
    attributes: {
      componentName: 'select',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(SelectWithoutAnalytics));